package com.caucho.services.server;

import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServiceContext {

   private static final ThreadLocal _localContext = new ThreadLocal();
   private ServletRequest _request;
   private ServletResponse _response;
   private String _serviceName;
   private String _objectId;
   private int _count;
   private HashMap _headers = new HashMap();


   public static void begin(ServletRequest request, ServletResponse response, String serviceName, String objectId) throws ServletException {
      ServiceContext context = (ServiceContext)_localContext.get();
      if(context == null) {
         context = new ServiceContext();
         _localContext.set(context);
      }

      context._request = request;
      context._response = response;
      context._serviceName = serviceName;
      context._objectId = objectId;
      ++context._count;
   }

   public static ServiceContext getContext() {
      return (ServiceContext)_localContext.get();
   }

   public void addHeader(String header, Object value) {
      this._headers.put(header, value);
   }

   public Object getHeader(String header) {
      return this._headers.get(header);
   }

   public static Object getContextHeader(String header) {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context.getHeader(header):null;
   }

   public static ServletRequest getContextRequest() {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context._request:null;
   }

   public static ServletResponse getContextResponse() {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context._response:null;
   }

   public static String getContextServiceName() {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context._serviceName:null;
   }

   public static String getContextObjectId() {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context._objectId:null;
   }

   public static void end() {
      ServiceContext context = (ServiceContext)_localContext.get();
      if(context != null && --context._count == 0) {
         context._request = null;
         context._response = null;
         context._headers.clear();
         _localContext.set((Object)null);
      }

   }

   /** @deprecated */
   public static ServletRequest getRequest() {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context._request:null;
   }

   /** @deprecated */
   public static String getServiceName() {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context._serviceName:null;
   }

   /** @deprecated */
   public static String getObjectId() {
      ServiceContext context = (ServiceContext)_localContext.get();
      return context != null?context._objectId:null;
   }

}
