package com.caucho.services.server;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class AbstractSkeleton {

   private Class _apiClass;
   private Class _homeClass;
   private Class _objectClass;
   private HashMap _methodMap = new HashMap();


   protected AbstractSkeleton(Class apiClass) {
      this._apiClass = apiClass;
      Method[] methodList = apiClass.getMethods();

      for(int i = 0; i < methodList.length; ++i) {
         Method method = methodList[i];
         if(this._methodMap.get(method.getName()) == null) {
            this._methodMap.put(method.getName(), methodList[i]);
         }

         Class[] param = method.getParameterTypes();
         String mangledName = method.getName() + "__" + param.length;
         this._methodMap.put(mangledName, methodList[i]);
         this._methodMap.put(mangleName(method, false), methodList[i]);
      }

   }

   public String getAPIClassName() {
      return this._apiClass.getName();
   }

   public String getHomeClassName() {
      return this._homeClass != null?this._homeClass.getName():this.getAPIClassName();
   }

   public void setHomeClass(Class homeAPI) {
      this._homeClass = homeAPI;
   }

   public String getObjectClassName() {
      return this._objectClass != null?this._objectClass.getName():this.getAPIClassName();
   }

   public void setObjectClass(Class objectAPI) {
      this._objectClass = objectAPI;
   }

   protected Method getMethod(String mangledName) {
      return (Method)this._methodMap.get(mangledName);
   }

   public static String mangleName(Method method, boolean isFull) {
      StringBuffer sb = new StringBuffer();
      sb.append(method.getName());
      Class[] params = method.getParameterTypes();

      for(int i = 0; i < params.length; ++i) {
         sb.append('_');
         sb.append(mangleClass(params[i], isFull));
      }

      return sb.toString();
   }

   public static String mangleClass(Class cl, boolean isFull) {
      String name = cl.getName();
      if(!name.equals("boolean") && !name.equals("java.lang.Boolean")) {
         if(!name.equals("int") && !name.equals("java.lang.Integer") && !name.equals("short") && !name.equals("java.lang.Short") && !name.equals("byte") && !name.equals("java.lang.Byte")) {
            if(!name.equals("long") && !name.equals("java.lang.Long")) {
               if(!name.equals("float") && !name.equals("java.lang.Float") && !name.equals("double") && !name.equals("java.lang.Double")) {
                  if(!name.equals("java.lang.String") && !name.equals("com.caucho.util.CharBuffer") && !name.equals("char") && !name.equals("java.lang.Character") && !name.equals("java.io.Reader")) {
                     if(!name.equals("java.util.Date") && !name.equals("com.caucho.util.QDate")) {
                        if(!InputStream.class.isAssignableFrom(cl) && !name.equals("[B")) {
                           if(cl.isArray()) {
                              return "[" + mangleClass(cl.getComponentType(), isFull);
                           } else if(!name.equals("org.w3c.dom.Node") && !name.equals("org.w3c.dom.Element") && !name.equals("org.w3c.dom.Document")) {
                              if(isFull) {
                                 return name;
                              } else {
                                 int p = name.lastIndexOf(46);
                                 return p > 0?name.substring(p + 1):name;
                              }
                           } else {
                              return "xml";
                           }
                        } else {
                           return "binary";
                        }
                     } else {
                        return "date";
                     }
                  } else {
                     return "string";
                  }
               } else {
                  return "double";
               }
            } else {
               return "long";
            }
         } else {
            return "int";
         }
      } else {
         return "boolean";
      }
   }

   public String toString() {
      return this.getClass().getSimpleName() + "[" + this._apiClass.getName() + "]";
   }
}
