package com.caucho.hessian.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class HessianFreeList {

   private final AtomicReferenceArray _freeStack;
   private final AtomicInteger _top = new AtomicInteger();


   public HessianFreeList(int size) {
      this._freeStack = new AtomicReferenceArray(size);
   }

   public Object allocate() {
      int top = this._top.get();
      return top > 0 && this._top.compareAndSet(top, top - 1)?this._freeStack.getAndSet(top - 1, (Object)null):null;
   }

   public boolean free(Object obj) {
      int top = this._top.get();
      if(top < this._freeStack.length()) {
         boolean isFree = this._freeStack.compareAndSet(top, (Object)null, obj);
         this._top.compareAndSet(top, top + 1);
         return isFree;
      } else {
         return false;
      }
   }

   public boolean allowFree(Object obj) {
      return this._top.get() < this._freeStack.length();
   }

   public void freeCareful(Object obj) {
      if(this.checkDuplicate(obj)) {
         throw new IllegalStateException("tried to free object twice: " + obj);
      } else {
         this.free(obj);
      }
   }

   public boolean checkDuplicate(Object obj) {
      int top = this._top.get();

      for(int i = top - 1; i >= 0; --i) {
         if(this._freeStack.get(i) == obj) {
            return true;
         }
      }

      return false;
   }
}
