package com.caucho.hessian.server;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hessian.io.HessianFactory;
import com.caucho.hessian.io.HessianInputFactory;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.io.HessianInputFactory.HeaderType;
import com.caucho.services.server.AbstractSkeleton;
import com.caucho.services.server.ServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianSkeleton extends AbstractSkeleton {

   private static final Logger log = Logger.getLogger(HessianSkeleton.class.getName());
   private boolean _isDebug;
   private HessianInputFactory _inputFactory = new HessianInputFactory();
   private HessianFactory _hessianFactory = new HessianFactory();
   private Object _service;


   public HessianSkeleton(Object service, Class apiClass) {
      super(apiClass);
      if(service == null) {
         service = this;
      }

      this._service = service;
      if(!apiClass.isAssignableFrom(service.getClass())) {
         throw new IllegalArgumentException("Service " + service + " must be an instance of " + apiClass.getName());
      }
   }

   public HessianSkeleton(Class apiClass) {
      super(apiClass);
   }

   public void setDebug(boolean isDebug) {
      this._isDebug = isDebug;
   }

   public boolean isDebug() {
      return this._isDebug;
   }

   public void setHessianFactory(HessianFactory factory) {
      this._hessianFactory = factory;
   }

   public void invoke(InputStream is, OutputStream os) throws Exception {
      this.invoke((InputStream)is, (OutputStream)os, (SerializerFactory)null);
   }

   public void invoke(InputStream is, OutputStream os, SerializerFactory serializerFactory) throws Exception {
      boolean isDebug = false;
      if(this.isDebugInvoke()) {
         isDebug = true;
         PrintWriter header = this.createDebugPrintWriter();
         HessianDebugInputStream in = new HessianDebugInputStream((InputStream)is, header);
         in.startTop2();
         is = in;
         HessianDebugOutputStream out = new HessianDebugOutputStream((OutputStream)os, header);
         out.startTop2();
         os = out;
      }

      HeaderType header1 = this._inputFactory.readHeader((InputStream)is);
      Object in1;
      Object out1;
      switch(HessianSkeleton.SyntheticClass_1.$SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[header1.ordinal()]) {
      case 1:
         in1 = this._hessianFactory.createHessianInput((InputStream)is);
         out1 = this._hessianFactory.createHessianOutput((OutputStream)os);
         break;
      case 2:
         in1 = this._hessianFactory.createHessianInput((InputStream)is);
         out1 = this._hessianFactory.createHessian2Output((OutputStream)os);
         break;
      case 3:
         in1 = this._hessianFactory.createHessian2Input((InputStream)is);
         ((AbstractHessianInput)in1).readCall();
         out1 = this._hessianFactory.createHessian2Output((OutputStream)os);
         break;
      default:
         throw new IllegalStateException(header1 + " is an unknown Hessian call");
      }

      if(serializerFactory != null) {
         ((AbstractHessianInput)in1).setSerializerFactory(serializerFactory);
         ((AbstractHessianOutput)out1).setSerializerFactory(serializerFactory);
      }

      try {
         this.invoke((Object)this._service, (AbstractHessianInput)in1, (AbstractHessianOutput)out1);
      } finally {
         ((AbstractHessianInput)in1).close();
         ((AbstractHessianOutput)out1).close();
         if(isDebug) {
            ((OutputStream)os).close();
         }

      }

   }

   public void invoke(AbstractHessianInput in, AbstractHessianOutput out) throws Exception {
      this.invoke((Object)this._service, (AbstractHessianInput)in, (AbstractHessianOutput)out);
   }

   public void invoke(Object service, AbstractHessianInput in, AbstractHessianOutput out) throws Exception {
      ServiceContext context = ServiceContext.getContext();
      in.skipOptionalCall();

      String header;
      while((header = in.readHeader()) != null) {
         Object methodName = in.readObject();
         context.addHeader(header, methodName);
      }

      String var15 = in.readMethod();
      int argLength = in.readMethodArgLength();
      Method method = this.getMethod(var15 + "__" + argLength);
      if(method == null) {
         method = this.getMethod(var15);
      }

      if(method == null) {
         if("_hessian_getAttribute".equals(var15)) {
            String var16 = in.readString();
            in.completeCall();
            String var17 = null;
            if("java.api.class".equals(var16)) {
               var17 = this.getAPIClassName();
            } else if("java.home.class".equals(var16)) {
               var17 = this.getHomeClassName();
            } else if("java.object.class".equals(var16)) {
               var17 = this.getObjectClassName();
            }

            out.writeReply(var17);
            out.close();
            return;
         }

         if(method == null) {
            out.writeFault("NoSuchMethodException", this.escapeMessage("The service has no method named: " + in.getMethod()), (Object)null);
            out.close();
            return;
         }
      }

      Class[] args = method.getParameterTypes();
      if(argLength != args.length && argLength >= 0) {
         out.writeFault("NoSuchMethod", this.escapeMessage("method " + method + " argument length mismatch, received length=" + argLength), (Object)null);
         out.close();
      } else {
         Object[] values = new Object[args.length];

         for(int result = 0; result < args.length; ++result) {
            values[result] = in.readObject(args[result]);
         }

         Object var18 = null;

         try {
            var18 = method.invoke(service, values);
         } catch (Exception var14) {
            Object e1 = var14;
            if(var14 instanceof InvocationTargetException) {
               e1 = ((InvocationTargetException)var14).getTargetException();
            }

            log.log(Level.FINE, this + " " + ((Throwable)e1).toString(), (Throwable)e1);
            out.writeFault("ServiceException", this.escapeMessage(((Throwable)e1).getMessage()), e1);
            out.close();
            return;
         }

         in.completeCall();
         out.writeReply(var18);
         out.close();
      }
   }

   private String escapeMessage(String msg) {
      if(msg == null) {
         return null;
      } else {
         StringBuilder sb = new StringBuilder();
         int length = msg.length();

         for(int i = 0; i < length; ++i) {
            char ch = msg.charAt(i);
            switch(ch) {
            case 0:
               sb.append("&#00;");
               break;
            case 38:
               sb.append("&amp;");
               break;
            case 60:
               sb.append("&lt;");
               break;
            case 62:
               sb.append("&gt;");
               break;
            default:
               sb.append(ch);
            }
         }

         return sb.toString();
      }
   }

   protected boolean isDebugInvoke() {
      return log.isLoggable(Level.FINEST) || this.isDebug() && log.isLoggable(Level.FINE);
   }

   protected PrintWriter createDebugPrintWriter() throws IOException {
      return new PrintWriter(new HessianSkeleton.LogWriter(log));
   }


   // $FF: synthetic class
   static class SyntheticClass_1 {

      // $FF: synthetic field
      static final int[] $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType = new int[HeaderType.values().length];


      static {
         try {
            $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[HeaderType.CALL_1_REPLY_1.ordinal()] = 1;
         } catch (NoSuchFieldError var3) {
            ;
         }

         try {
            $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[HeaderType.CALL_1_REPLY_2.ordinal()] = 2;
         } catch (NoSuchFieldError var2) {
            ;
         }

         try {
            $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[HeaderType.HESSIAN_2.ordinal()] = 3;
         } catch (NoSuchFieldError var1) {
            ;
         }

      }
   }

   static class LogWriter extends Writer {

      private Logger _log;
      private StringBuilder _sb = new StringBuilder();


      LogWriter(Logger log) {
         this._log = log;
      }

      public void write(char ch) {
         if(ch == 10 && this._sb.length() > 0) {
            this._log.fine(this._sb.toString());
            this._sb.setLength(0);
         } else {
            this._sb.append(ch);
         }

      }

      public void write(char[] buffer, int offset, int length) {
         for(int i = 0; i < length; ++i) {
            char ch = buffer[offset + i];
            if(ch == 10 && this._sb.length() > 0) {
               this._log.fine(this._sb.toString());
               this._sb.setLength(0);
            } else {
               this._sb.append(ch);
            }
         }

      }

      public void flush() {
      }

      public void close() {
      }
   }
}
