package com.caucho.hessian.server;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import com.caucho.services.server.Service;
import com.caucho.services.server.ServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HessianServlet extends HttpServlet {

   private Class _homeAPI;
   private Object _homeImpl;
   private Class _objectAPI;
   private Object _objectImpl;
   private HessianSkeleton _homeSkeleton;
   private HessianSkeleton _objectSkeleton;
   private SerializerFactory _serializerFactory;


   public String getServletInfo() {
      return "Hessian Servlet";
   }

   public void setHomeAPI(Class api) {
      this._homeAPI = api;
   }

   public void setHome(Object home) {
      this._homeImpl = home;
   }

   public void setObjectAPI(Class api) {
      this._objectAPI = api;
   }

   public void setObject(Object object) {
      this._objectImpl = object;
   }

   public void setService(Object service) {
      this.setHome(service);
   }

   public void setAPIClass(Class api) {
      this.setHomeAPI(api);
   }

   public Class getAPIClass() {
      return this._homeAPI;
   }

   public void setSerializerFactory(SerializerFactory factory) {
      this._serializerFactory = factory;
   }

   public SerializerFactory getSerializerFactory() {
      if(this._serializerFactory == null) {
         this._serializerFactory = new SerializerFactory();
      }

      return this._serializerFactory;
   }

   public void setSendCollectionType(boolean sendType) {
      this.getSerializerFactory().setSendCollectionType(sendType);
   }

   public void setDebug(boolean isDebug) {
   }

   public void setLogName(String name) {
   }

   public void init(ServletConfig config) throws ServletException {
      super.init(config);

      try {
         String e;
         Class objectClass;
         if(this._homeImpl == null) {
            if(this.getInitParameter("home-class") != null) {
               e = this.getInitParameter("home-class");
               objectClass = this.loadClass(e);
               this._homeImpl = objectClass.newInstance();
               this.init((Object)this._homeImpl);
            } else if(this.getInitParameter("service-class") != null) {
               e = this.getInitParameter("service-class");
               objectClass = this.loadClass(e);
               this._homeImpl = objectClass.newInstance();
               this.init((Object)this._homeImpl);
            } else {
               if(this.getClass().equals(HessianServlet.class)) {
                  throw new ServletException("server must extend HessianServlet");
               }

               this._homeImpl = this;
            }
         }

         if(this._homeAPI == null) {
            if(this.getInitParameter("home-api") != null) {
               e = this.getInitParameter("home-api");
               this._homeAPI = this.loadClass(e);
            } else if(this.getInitParameter("api-class") != null) {
               e = this.getInitParameter("api-class");
               this._homeAPI = this.loadClass(e);
            } else if(this._homeImpl != null) {
               this._homeAPI = this.findRemoteAPI(this._homeImpl.getClass());
               if(this._homeAPI == null) {
                  this._homeAPI = this._homeImpl.getClass();
               }

               this._homeAPI = this._homeImpl.getClass();
            }
         }

         if(this._objectImpl == null && this.getInitParameter("object-class") != null) {
            e = this.getInitParameter("object-class");
            objectClass = this.loadClass(e);
            this._objectImpl = objectClass.newInstance();
            this.init((Object)this._objectImpl);
         }

         if(this._objectAPI == null) {
            if(this.getInitParameter("object-api") != null) {
               e = this.getInitParameter("object-api");
               this._objectAPI = this.loadClass(e);
            } else if(this._objectImpl != null) {
               this._objectAPI = this._objectImpl.getClass();
            }
         }

         this._homeSkeleton = new HessianSkeleton(this._homeImpl, this._homeAPI);
         if(this._objectAPI != null) {
            this._homeSkeleton.setObjectClass(this._objectAPI);
         }

         if(this._objectImpl != null) {
            this._objectSkeleton = new HessianSkeleton(this._objectImpl, this._objectAPI);
            this._objectSkeleton.setHomeClass(this._homeAPI);
         } else {
            this._objectSkeleton = this._homeSkeleton;
         }

         if("true".equals(this.getInitParameter("debug"))) {
            ;
         }

         if("false".equals(this.getInitParameter("send-collection-type"))) {
            this.setSendCollectionType(false);
         }

      } catch (ServletException var4) {
         throw var4;
      } catch (Exception var5) {
         throw new ServletException(var5);
      }
   }

   private Class findRemoteAPI(Class implClass) {
      return null;
   }

   private Class loadClass(String className) throws ClassNotFoundException {
      ClassLoader loader = this.getContextClassLoader();
      return loader != null?Class.forName(className, false, loader):Class.forName(className);
   }

   protected ClassLoader getContextClassLoader() {
      return Thread.currentThread().getContextClassLoader();
   }

   private void init(Object service) throws ServletException {
      if(this.getClass().equals(HessianServlet.class)) {
         if(service instanceof Service) {
            ((Service)service).init(this.getServletConfig());
         } else if(service instanceof Servlet) {
            ((Servlet)service).init(this.getServletConfig());
         }
      }

   }

   public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
      HttpServletRequest req = (HttpServletRequest)request;
      HttpServletResponse res = (HttpServletResponse)response;
      if(!req.getMethod().equals("POST")) {
         res.setStatus(500);
         PrintWriter serviceId1 = res.getWriter();
         res.setContentType("text/html");
         serviceId1.println("<h1>Hessian Requires POST</h1>");
      } else {
         String serviceId = req.getPathInfo();
         String objectId = req.getParameter("id");
         if(objectId == null) {
            objectId = req.getParameter("ejbid");
         }

         ServiceContext.begin(req, res, serviceId, objectId);

         try {
            ServletInputStream e = request.getInputStream();
            ServletOutputStream os = response.getOutputStream();
            response.setContentType("x-application/hessian");
            SerializerFactory serializerFactory = this.getSerializerFactory();
            this.invoke(e, os, objectId, serializerFactory);
         } catch (RuntimeException var15) {
            throw var15;
         } catch (ServletException var16) {
            throw var16;
         } catch (Throwable var17) {
            throw new ServletException(var17);
         } finally {
            ServiceContext.end();
         }

      }
   }

   protected void invoke(InputStream is, OutputStream os, String objectId, SerializerFactory serializerFactory) throws Exception {
      if(objectId != null) {
         this._objectSkeleton.invoke((InputStream)is, (OutputStream)os, (SerializerFactory)serializerFactory);
      } else {
         this._homeSkeleton.invoke((InputStream)is, (OutputStream)os, (SerializerFactory)serializerFactory);
      }

   }

   protected Hessian2Input createHessian2Input(InputStream is) {
      return new Hessian2Input(is);
   }

   static class LogWriter extends Writer {

      private Logger _log;
      private StringBuilder _sb = new StringBuilder();


      LogWriter(Logger log) {
         this._log = log;
      }

      public void write(char ch) {
         if(ch == 10 && this._sb.length() > 0) {
            this._log.fine(this._sb.toString());
            this._sb.setLength(0);
         } else {
            this._sb.append(ch);
         }

      }

      public void write(char[] buffer, int offset, int length) {
         for(int i = 0; i < length; ++i) {
            char ch = buffer[offset + i];
            if(ch == 10 && this._sb.length() > 0) {
               this._log.fine(this._sb.toString());
               this._sb.setLength(0);
            } else {
               this._sb.append(ch);
            }
         }

      }

      public void flush() {
      }

      public void close() {
      }
   }
}
