package com.caucho.hessian.mux;

import com.caucho.hessian.mux.MuxInputStream;
import com.caucho.hessian.mux.MuxOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MuxServer {

   private Object READ_LOCK = new Object();
   private Object WRITE_LOCK = new Object();
   private InputStream is;
   private OutputStream os;
   private boolean isClient;
   private transient boolean isClosed;
   private boolean[] inputReady = new boolean[4];
   private boolean isReadLocked;
   private boolean isWriteLocked;


   public MuxServer() {
   }

   public MuxServer(InputStream is, OutputStream os, boolean isClient) {
      this.init(is, os, isClient);
   }

   public void init(InputStream is, OutputStream os, boolean isClient) {
      this.is = is;
      this.os = os;
      this.isClient = isClient;
   }

   public InputStream getInputStream() {
      return this.is;
   }

   public OutputStream getOutputStream() {
      return this.os;
   }

   public boolean startCall(MuxInputStream in, MuxOutputStream out) throws IOException {
      int channel = this.isClient?2:3;
      return this.startCall(channel, in, out);
   }

   public boolean startCall(int channel, MuxInputStream in, MuxOutputStream out) throws IOException {
      in.init(this, channel);
      out.init(this, channel);
      return true;
   }

   public boolean readRequest(MuxInputStream in, MuxOutputStream out) throws IOException {
      int channel = this.isClient?3:2;
      in.init(this, channel);
      out.init(this, channel);
      if(this.readChannel(channel) != null) {
         in.setInputStream(this.is);
         in.readToData(false);
         return true;
      } else {
         return false;
      }
   }

   OutputStream writeChannel(int channel) throws IOException {
      while(true) {
         if(this.os != null) {
            boolean canWrite = false;
            Object var3 = this.WRITE_LOCK;
            synchronized(this.WRITE_LOCK) {
               if(!this.isWriteLocked) {
                  this.isWriteLocked = true;
                  canWrite = true;
               } else {
                  try {
                     this.WRITE_LOCK.wait(5000L);
                  } catch (Exception var6) {
                     ;
                  }
               }
            }

            if(!canWrite) {
               continue;
            }

            this.os.write(67);
            this.os.write(channel >> 8);
            this.os.write(channel);
            return this.os;
         }

         return null;
      }
   }

   void yield(int channel) throws IOException {
      this.os.write(89);
      this.freeWriteLock();
   }

   void flush(int channel) throws IOException {
      this.os.write(89);
      this.os.flush();
      this.freeWriteLock();
   }

   void close(int channel) throws IOException {
      if(this.os != null) {
         this.os.write(81);
         this.os.flush();
         this.freeWriteLock();
      }

   }

   void freeWriteLock() {
      Object var1 = this.WRITE_LOCK;
      synchronized(this.WRITE_LOCK) {
         this.isWriteLocked = false;
         this.WRITE_LOCK.notifyAll();
      }
   }

   InputStream readChannel(int channel) throws IOException {
      while(!this.isClosed) {
         if(this.inputReady[channel]) {
            this.inputReady[channel] = false;
            return this.is;
         }

         boolean canRead = false;
         Object e = this.READ_LOCK;
         synchronized(this.READ_LOCK) {
            if(!this.isReadLocked) {
               this.isReadLocked = true;
               canRead = true;
            } else {
               try {
                  this.READ_LOCK.wait(5000L);
               } catch (Exception var7) {
                  ;
               }
            }
         }

         if(canRead) {
            try {
               this.readData();
            } catch (IOException var6) {
               this.close();
            }
         }
      }

      return null;
   }

   boolean getReadLock() {
      Object var1 = this.READ_LOCK;
      synchronized(this.READ_LOCK) {
         if(!this.isReadLocked) {
            this.isReadLocked = true;
            return true;
         } else {
            try {
               this.READ_LOCK.wait(5000L);
            } catch (Exception var4) {
               ;
            }

            return false;
         }
      }
   }

   void freeReadLock() {
      Object var1 = this.READ_LOCK;
      synchronized(this.READ_LOCK) {
         this.isReadLocked = false;
         this.READ_LOCK.notifyAll();
      }
   }

   private void readData() throws IOException {
      while(!this.isClosed) {
         int code = this.is.read();
         int channel;
         switch(code) {
         case -1:
            this.close();
            return;
         case 9:
         case 10:
         case 13:
         case 32:
            break;
         case 67:
            channel = (this.is.read() << 8) + this.is.read();
            this.inputReady[channel] = true;
            return;
         case 69:
            channel = (this.is.read() << 8) + this.is.read();
            int status = (this.is.read() << 8) + this.is.read();
            this.inputReady[channel] = true;
            return;
         default:
            this.close();
            return;
         }
      }

   }

   public void close() throws IOException {
      this.isClosed = true;
      OutputStream os = this.os;
      this.os = null;
      InputStream is = this.is;
      this.is = null;
      if(os != null) {
         os.close();
      }

      if(is != null) {
         is.close();
      }

   }
}
