package com.caucho.hessian.mux;

import com.caucho.hessian.mux.MuxServer;
import java.io.IOException;
import java.io.InputStream;

public class MuxInputStream extends InputStream {

   private MuxServer server;
   protected InputStream is;
   private int channel;
   private String url;
   private int chunkLength;


   protected void init(MuxServer server, int channel) throws IOException {
      this.server = server;
      this.channel = channel;
      this.url = null;
      this.chunkLength = 0;
   }

   protected InputStream getInputStream() throws IOException {
      if(this.is == null && this.server != null) {
         this.is = this.server.readChannel(this.channel);
      }

      return this.is;
   }

   void setInputStream(InputStream is) {
      this.is = is;
   }

   public int getChannel() {
      return this.channel;
   }

   public String getURL() {
      return this.url;
   }

   public int read() throws IOException {
      if(this.chunkLength <= 0) {
         this.readToData(false);
         if(this.chunkLength <= 0) {
            return -1;
         }
      }

      --this.chunkLength;
      return this.is.read();
   }

   public void close() throws IOException {
      this.skipToEnd();
   }

   private void skipToEnd() throws IOException {
      InputStream is = this.getInputStream();
      if(is != null) {
         if(this.chunkLength > 0) {
            is.skip((long)this.chunkLength);
         }

         for(int tag = is.read(); tag >= 0; tag = is.read()) {
            switch(tag) {
            case -1:
               this.server.freeReadLock();
               this.is = null;
               this.server = null;
               return;
            case 81:
               this.server.freeReadLock();
               this.is = null;
               this.server = null;
               return;
            case 89:
               this.server.freeReadLock();
               this.is = is = this.server.readChannel(this.channel);
               if(is == null) {
                  this.server = null;
                  return;
               }
               break;
            default:
               int length = (is.read() << 8) + is.read();
               is.skip((long)length);
            }
         }

      }
   }

   void readToData(boolean returnOnYield) throws IOException {
      InputStream is = this.getInputStream();
      if(is != null) {
         for(int tag = is.read(); tag >= 0; tag = is.read()) {
            switch(tag) {
            case 68:
               this.chunkLength = (is.read() << 8) + is.read();
               return;
            case 81:
               this.server.freeReadLock();
               this.is = null;
               this.server = null;
               return;
            case 85:
               this.url = this.readUTF();
               break;
            case 89:
               this.server.freeReadLock();
               if(returnOnYield) {
                  return;
               }

               this.server.readChannel(this.channel);
               break;
            default:
               this.readTag(tag);
            }
         }

      }
   }

   protected void readTag(int tag) throws IOException {
      int length = (this.is.read() << 8) + this.is.read();
      this.is.skip((long)length);
   }

   protected String readUTF() throws IOException {
      int len = (this.is.read() << 8) + this.is.read();
      StringBuffer sb = new StringBuffer();

      while(len > 0) {
         int d1 = this.is.read();
         if(d1 < 0) {
            return sb.toString();
         }

         if(d1 < 128) {
            --len;
            sb.append((char)d1);
         } else if((d1 & 224) == 192) {
            len -= 2;
            sb.append(((d1 & 31) << 6) + (this.is.read() & 63));
         } else {
            if((d1 & 240) != 224) {
               throw new IOException("utf-8 encoding error");
            }

            len -= 3;
            sb.append(((d1 & 15) << 12) + ((this.is.read() & 63) << 6) + (this.is.read() & 63));
         }
      }

      return sb.toString();
   }
}
