package com.caucho.hessian.micro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MicroHessianOutput {

   protected OutputStream os;


   public MicroHessianOutput(OutputStream os) {
      this.init(os);
   }

   public MicroHessianOutput() {
   }

   public void init(OutputStream os) {
      this.os = os;
   }

   public void startCall(String method) throws IOException {
      this.os.write(99);
      this.os.write(0);
      this.os.write(1);
      this.os.write(109);
      int len = method.length();
      this.os.write(len >> 8);
      this.os.write(len);
      this.printString(method, 0, len);
   }

   public void completeCall() throws IOException {
      this.os.write(122);
   }

   public void writeBoolean(boolean value) throws IOException {
      if(value) {
         this.os.write(84);
      } else {
         this.os.write(70);
      }

   }

   public void writeInt(int value) throws IOException {
      this.os.write(73);
      this.os.write(value >> 24);
      this.os.write(value >> 16);
      this.os.write(value >> 8);
      this.os.write(value);
   }

   public void writeLong(long value) throws IOException {
      this.os.write(76);
      this.os.write((byte)((int)(value >> 56)));
      this.os.write((byte)((int)(value >> 48)));
      this.os.write((byte)((int)(value >> 40)));
      this.os.write((byte)((int)(value >> 32)));
      this.os.write((byte)((int)(value >> 24)));
      this.os.write((byte)((int)(value >> 16)));
      this.os.write((byte)((int)(value >> 8)));
      this.os.write((byte)((int)value));
   }

   public void writeUTCDate(long time) throws IOException {
      this.os.write(100);
      this.os.write((byte)((int)(time >> 56)));
      this.os.write((byte)((int)(time >> 48)));
      this.os.write((byte)((int)(time >> 40)));
      this.os.write((byte)((int)(time >> 32)));
      this.os.write((byte)((int)(time >> 24)));
      this.os.write((byte)((int)(time >> 16)));
      this.os.write((byte)((int)(time >> 8)));
      this.os.write((byte)((int)time));
   }

   public void writeNull() throws IOException {
      this.os.write(78);
   }

   public void writeString(String value) throws IOException {
      if(value == null) {
         this.os.write(78);
      } else {
         int len = value.length();
         this.os.write(83);
         this.os.write(len >> 8);
         this.os.write(len);
         this.printString(value);
      }

   }

   public void writeBytes(byte[] buffer) throws IOException {
      if(buffer == null) {
         this.os.write(78);
      } else {
         this.writeBytes(buffer, 0, buffer.length);
      }

   }

   public void writeBytes(byte[] buffer, int offset, int length) throws IOException {
      if(buffer == null) {
         this.os.write(78);
      } else {
         this.os.write(66);
         this.os.write(length << 8);
         this.os.write(length);
         this.os.write(buffer, offset, length);
      }

   }

   public void writeRef(int value) throws IOException {
      this.os.write(82);
      this.os.write(value << 24);
      this.os.write(value << 16);
      this.os.write(value << 8);
      this.os.write(value);
   }

   public void writeObject(Object object) throws IOException {
      if(object == null) {
         this.writeNull();
      } else if(object instanceof String) {
         this.writeString((String)object);
      } else if(object instanceof Boolean) {
         this.writeBoolean(((Boolean)object).booleanValue());
      } else if(object instanceof Integer) {
         this.writeInt(((Integer)object).intValue());
      } else if(object instanceof Long) {
         this.writeLong(((Long)object).longValue());
      } else if(object instanceof Date) {
         this.writeUTCDate(((Date)object).getTime());
      } else if(object instanceof byte[]) {
         byte[] hashtable = (byte[])((byte[])object);
         this.writeBytes(hashtable, 0, hashtable.length);
      } else if(object instanceof Vector) {
         Vector var6 = (Vector)object;
         int e = var6.size();
         this.writeListBegin(e, (String)null);

         for(int key = 0; key < e; ++key) {
            this.writeObject(var6.elementAt(key));
         }

         this.writeListEnd();
      } else if(object instanceof Hashtable) {
         Hashtable var7 = (Hashtable)object;
         this.writeMapBegin((String)null);
         Enumeration var8 = var7.keys();

         while(var8.hasMoreElements()) {
            Object var9 = var8.nextElement();
            Object value = var7.get(var9);
            this.writeObject(var9);
            this.writeObject(value);
         }

         this.writeMapEnd();
      } else {
         this.writeCustomObject(object);
      }

   }

   public void writeCustomObject(Object object) throws IOException {
      throw new IOException("unexpected object: " + object);
   }

   public void writeListBegin(int length, String type) throws IOException {
      this.os.write(86);
      this.os.write(116);
      this.printLenString(type);
      this.os.write(108);
      this.os.write(length >> 24);
      this.os.write(length >> 16);
      this.os.write(length >> 8);
      this.os.write(length);
   }

   public void writeListEnd() throws IOException {
      this.os.write(122);
   }

   public void writeMapBegin(String type) throws IOException {
      this.os.write(77);
      this.os.write(116);
      this.printLenString(type);
   }

   public void writeMapEnd() throws IOException {
      this.os.write(122);
   }

   public void writeRemote(String type, String url) throws IOException {
      this.os.write(114);
      this.os.write(116);
      this.printLenString(type);
      this.os.write(83);
      this.printLenString(url);
   }

   public void printLenString(String v) throws IOException {
      if(v == null) {
         this.os.write(0);
         this.os.write(0);
      } else {
         int len = v.length();
         this.os.write(len >> 8);
         this.os.write(len);
         this.printString(v, 0, len);
      }

   }

   public void printString(String v) throws IOException {
      this.printString(v, 0, v.length());
   }

   public void printString(String v, int offset, int length) throws IOException {
      for(int i = 0; i < length; ++i) {
         char ch = v.charAt(i + offset);
         if(ch < 128) {
            this.os.write(ch);
         } else if(ch < 2048) {
            this.os.write(192 + (ch >> 6 & 31));
            this.os.write(128 + (ch & 63));
         } else {
            this.os.write(224 + (ch >> 12 & 15));
            this.os.write(128 + (ch >> 6 & 63));
            this.os.write(128 + (ch & 63));
         }
      }

   }
}
