package com.caucho.hessian.micro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class MicroHessianInput {

   protected InputStream is;


   public MicroHessianInput(InputStream is) {
      this.init(is);
   }

   public MicroHessianInput() {
   }

   public void init(InputStream is) {
      this.is = is;
   }

   public void startReply() throws IOException {
      int tag = this.is.read();
      if(tag != 114) {
         this.protocolException("expected hessian reply");
      }

      int major = this.is.read();
      int minor = this.is.read();
   }

   public void completeReply() throws IOException {
      int tag = this.is.read();
      if(tag != 122) {
         this.protocolException("expected end of reply");
      }

   }

   public boolean readBoolean() throws IOException {
      int tag = this.is.read();
      switch(tag) {
      case 70:
         return false;
      case 84:
         return true;
      default:
         throw this.expect("boolean", tag);
      }
   }

   public int readInt() throws IOException {
      int tag = this.is.read();
      if(tag != 73) {
         throw this.expect("integer", tag);
      } else {
         int b32 = this.is.read();
         int b24 = this.is.read();
         int b16 = this.is.read();
         int b8 = this.is.read();
         return (b32 << 24) + (b24 << 16) + (b16 << 8) + b8;
      }
   }

   public long readLong() throws IOException {
      int tag = this.is.read();
      if(tag != 76) {
         throw this.protocolException("expected long");
      } else {
         long b64 = (long)this.is.read();
         long b56 = (long)this.is.read();
         long b48 = (long)this.is.read();
         long b40 = (long)this.is.read();
         long b32 = (long)this.is.read();
         long b24 = (long)this.is.read();
         long b16 = (long)this.is.read();
         long b8 = (long)this.is.read();
         return (b64 << 56) + (b56 << 48) + (b48 << 40) + (b40 << 32) + (b32 << 24) + (b24 << 16) + (b16 << 8) + b8;
      }
   }

   public long readUTCDate() throws IOException {
      int tag = this.is.read();
      if(tag != 100) {
         throw this.protocolException("expected date");
      } else {
         long b64 = (long)this.is.read();
         long b56 = (long)this.is.read();
         long b48 = (long)this.is.read();
         long b40 = (long)this.is.read();
         long b32 = (long)this.is.read();
         long b24 = (long)this.is.read();
         long b16 = (long)this.is.read();
         long b8 = (long)this.is.read();
         return (b64 << 56) + (b56 << 48) + (b48 << 40) + (b40 << 32) + (b32 << 24) + (b24 << 16) + (b16 << 8) + b8;
      }
   }

   public String readString() throws IOException {
      int tag = this.is.read();
      if(tag == 78) {
         return null;
      } else if(tag != 83) {
         throw this.expect("string", tag);
      } else {
         int b16 = this.is.read();
         int b8 = this.is.read();
         int len = (b16 << 8) + b8;
         return this.readStringImpl(len);
      }
   }

   public byte[] readBytes() throws IOException {
      int tag = this.is.read();
      if(tag == 78) {
         return null;
      } else if(tag != 66) {
         throw this.expect("bytes", tag);
      } else {
         int b16 = this.is.read();
         int b8 = this.is.read();
         int len = (b16 << 8) + b8;
         ByteArrayOutputStream bos = new ByteArrayOutputStream();

         for(int i = 0; i < len; ++i) {
            bos.write(this.is.read());
         }

         return bos.toByteArray();
      }
   }

   public Object readObject(Class expectedClass) throws IOException {
      int tag = this.is.read();
      long b16;
      int b8;
      long len;
      long i;
      long b40;
      long b32;
      long b24;
      long b161;
      long b81;
      int var19;
      int var20;
      switch(tag) {
      case 66:
         if(tag != 66) {
            throw this.expect("bytes", tag);
         }

         var19 = this.is.read();
         b8 = this.is.read();
         var20 = (var19 << 8) + b8;
         ByteArrayOutputStream var21 = new ByteArrayOutputStream();

         for(int var22 = 0; var22 < var20; ++var22) {
            var21.write(this.is.read());
         }

         return var21.toByteArray();
      case 67:
      case 68:
      case 69:
      case 71:
      case 72:
      case 74:
      case 75:
      case 77:
      case 79:
      case 80:
      case 81:
      case 82:
      case 85:
      case 86:
      case 87:
      case 89:
      case 90:
      case 91:
      case 92:
      case 93:
      case 94:
      case 95:
      case 96:
      case 97:
      case 98:
      case 99:
      default:
         throw new IOException("unknown code:" + (char)tag);
      case 70:
         return new Boolean(false);
      case 73:
         var19 = this.is.read();
         b8 = this.is.read();
         var20 = this.is.read();
         int bos = this.is.read();
         return new Integer((var19 << 24) + (b8 << 16) + (var20 << 8) + bos);
      case 76:
         b16 = (long)this.is.read();
         len = (long)this.is.read();
         i = (long)this.is.read();
         b40 = (long)this.is.read();
         b32 = (long)this.is.read();
         b24 = (long)this.is.read();
         b161 = (long)this.is.read();
         b81 = (long)this.is.read();
         return new Long((b16 << 56) + (len << 48) + (i << 40) + (b40 << 32) + (b32 << 24) + (b24 << 16) + (b161 << 8) + b81);
      case 78:
         return null;
      case 83:
      case 88:
         var19 = this.is.read();
         b8 = this.is.read();
         var20 = (var19 << 8) + b8;
         return this.readStringImpl(var20);
      case 84:
         return new Boolean(true);
      case 100:
         b16 = (long)this.is.read();
         len = (long)this.is.read();
         i = (long)this.is.read();
         b40 = (long)this.is.read();
         b32 = (long)this.is.read();
         b24 = (long)this.is.read();
         b161 = (long)this.is.read();
         b81 = (long)this.is.read();
         return new Date((b16 << 56) + (len << 48) + (i << 40) + (b40 << 32) + (b32 << 24) + (b24 << 16) + (b161 << 8) + b81);
      }
   }

   protected String readStringImpl(int length) throws IOException {
      StringBuffer sb = new StringBuffer();

      for(int i = 0; i < length; ++i) {
         int ch = this.is.read();
         if(ch < 128) {
            sb.append((char)ch);
         } else {
            int ch1;
            int ch2;
            if((ch & 224) == 192) {
               ch1 = this.is.read();
               ch2 = ((ch & 31) << 6) + (ch1 & 63);
               sb.append((char)ch2);
            } else {
               if((ch & 240) != 224) {
                  throw new IOException("bad utf-8 encoding");
               }

               ch1 = this.is.read();
               ch2 = this.is.read();
               int v = ((ch & 15) << 12) + ((ch1 & 63) << 6) + (ch2 & 63);
               sb.append((char)v);
            }
         }
      }

      return sb.toString();
   }

   protected IOException expect(String expect, int ch) {
      return ch < 0?this.protocolException("expected " + expect + " at end of file"):this.protocolException("expected " + expect + " at " + (char)ch);
   }

   protected IOException protocolException(String message) {
      return new IOException(message);
   }
}
