package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class ObjectInstanceDeserializer extends AbstractDeserializer {

   public Class getType() {
      return ObjectInstance.class;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      String className = null;
      ObjectName objectName = null;
      Object initValue = null;

      while(!in.isEnd()) {
         String e = in.readString();
         if("className".equals(e)) {
            className = in.readString();
         } else if("name".equals(e)) {
            objectName = (ObjectName)in.readObject(ObjectName.class);
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();

      try {
         return new ObjectInstance(objectName, className);
      } catch (Exception var6) {
         throw new IOException(String.valueOf(var6));
      }
   }
}
