package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import javax.management.MBeanParameterInfo;

public class MBeanParameterInfoDeserializer extends AbstractDeserializer {

   public Class getType() {
      return MBeanParameterInfo.class;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      String name = null;
      String type = null;
      String description = null;
      boolean isRead = false;
      boolean isWrite = false;
      boolean isIs = false;

      while(!in.isEnd()) {
         String e = in.readString();
         if("name".equals(e)) {
            name = in.readString();
         } else if("type".equals(e)) {
            type = in.readString();
         } else if("description".equals(e)) {
            description = in.readString();
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();

      try {
         MBeanParameterInfo e1 = new MBeanParameterInfo(name, type, description);
         return e1;
      } catch (Exception var9) {
         throw new IOException(String.valueOf(var9));
      }
   }
}
