package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfoDeserializer extends AbstractDeserializer {

   public Class getType() {
      return MBeanOperationInfo.class;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      String name = null;
      String type = null;
      String description = null;
      MBeanParameterInfo[] sig = null;
      int impact = 0;

      while(!in.isEnd()) {
         String e = in.readString();
         if("name".equals(e)) {
            name = in.readString();
         } else if("description".equals(e)) {
            description = in.readString();
         } else if("type".equals(e)) {
            type = in.readString();
         } else if("impact".equals(e)) {
            impact = in.readInt();
         } else if("signature".equals(e)) {
            sig = (MBeanParameterInfo[])((MBeanParameterInfo[])in.readObject(MBeanParameterInfo[].class));
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();

      try {
         MBeanOperationInfo e1 = new MBeanOperationInfo(name, description, sig, type, impact);
         return e1;
      } catch (Exception var8) {
         throw new IOException(String.valueOf(var8));
      }
   }
}
