package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import javax.management.MBeanNotificationInfo;

public class MBeanNotificationInfoDeserializer extends AbstractDeserializer {

   public Class getType() {
      return MBeanNotificationInfo.class;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      String name = null;
      String description = null;
      String[] types = null;

      while(!in.isEnd()) {
         String e = in.readString();
         if("name".equals(e)) {
            name = in.readString();
         } else if("description".equals(e)) {
            description = in.readString();
         } else if("types".equals(e)) {
            types = (String[])((String[])in.readObject(String[].class));
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();

      try {
         MBeanNotificationInfo e1 = new MBeanNotificationInfo(types, name, description);
         return e1;
      } catch (Exception var6) {
         throw new IOException(String.valueOf(var6));
      }
   }
}
