package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfoDeserializer extends AbstractDeserializer {

   public Class getType() {
      return MBeanInfo.class;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      String className = null;
      String description = null;
      MBeanAttributeInfo[] attributes = null;
      Object constructors = null;
      Object operations = null;
      Object notifications = null;

      while(!in.isEnd()) {
         String e = in.readString();
         if("className".equals(e)) {
            className = in.readString();
         } else if("description".equals(e)) {
            description = in.readString();
         } else if("attributes".equals(e)) {
            attributes = (MBeanAttributeInfo[])((MBeanAttributeInfo[])in.readObject(MBeanAttributeInfo[].class));
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();

      try {
         MBeanInfo e1 = new MBeanInfo(className, description, attributes, (MBeanConstructorInfo[])constructors, (MBeanOperationInfo[])operations, (MBeanNotificationInfo[])notifications);
         return e1;
      } catch (Exception var9) {
         throw new IOException(String.valueOf(var9));
      }
   }
}
