package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfoDeserializer extends AbstractDeserializer {

   public Class getType() {
      return MBeanConstructorInfo.class;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      String name = null;
      String description = null;
      MBeanParameterInfo[] sig = null;

      while(!in.isEnd()) {
         String e = in.readString();
         if("name".equals(e)) {
            name = in.readString();
         } else if("description".equals(e)) {
            description = in.readString();
         } else if("signature".equals(e)) {
            sig = (MBeanParameterInfo[])((MBeanParameterInfo[])in.readObject(MBeanParameterInfo[].class));
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();

      try {
         MBeanConstructorInfo e1 = new MBeanConstructorInfo(name, description, sig);
         return e1;
      } catch (Exception var6) {
         throw new IOException(String.valueOf(var6));
      }
   }
}
