package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;
import javax.management.MBeanAttributeInfo;

public class MBeanAttributeInfoDeserializer extends AbstractDeserializer {

   public Class getType() {
      return MBeanAttributeInfo.class;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      String name = null;
      String type = null;
      String description = null;
      boolean isRead = false;
      boolean isWrite = false;
      boolean isIs = false;

      while(!in.isEnd()) {
         String e = in.readString();
         if("name".equals(e)) {
            name = in.readString();
         } else if("attributeType".equals(e)) {
            type = in.readString();
         } else if("description".equals(e)) {
            description = in.readString();
         } else if("isRead".equals(e)) {
            isRead = in.readBoolean();
         } else if("isWrite".equals(e)) {
            isWrite = in.readBoolean();
         } else if("is".equals(e)) {
            isIs = in.readBoolean();
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();

      try {
         MBeanAttributeInfo e1 = new MBeanAttributeInfo(name, type, description, isRead, isWrite, isIs);
         return e1;
      } catch (Exception var9) {
         throw new IOException(String.valueOf(var9));
      }
   }
}
