package com.caucho.hessian.jmx;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.StringValueDeserializer;
import com.caucho.hessian.io.StringValueSerializer;
import com.caucho.hessian.jmx.MBeanAttributeInfoDeserializer;
import com.caucho.hessian.jmx.MBeanConstructorInfoDeserializer;
import com.caucho.hessian.jmx.MBeanNotificationInfoDeserializer;
import com.caucho.hessian.jmx.MBeanOperationInfoDeserializer;
import com.caucho.hessian.jmx.MBeanParameterInfoDeserializer;
import com.caucho.hessian.jmx.ObjectInstanceDeserializer;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class JMXSerializerFactory extends AbstractSerializerFactory {

   public Serializer getSerializer(Class cl) throws HessianProtocolException {
      return ObjectName.class.equals(cl)?new StringValueSerializer():null;
   }

   public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
      return (Deserializer)(ObjectName.class.equals(cl)?new StringValueDeserializer(cl):(ObjectInstance.class.equals(cl)?new ObjectInstanceDeserializer():(MBeanAttributeInfo.class.isAssignableFrom(cl)?new MBeanAttributeInfoDeserializer():(MBeanConstructorInfo.class.isAssignableFrom(cl)?new MBeanConstructorInfoDeserializer():(MBeanOperationInfo.class.isAssignableFrom(cl)?new MBeanOperationInfoDeserializer():(MBeanParameterInfo.class.isAssignableFrom(cl)?new MBeanParameterInfoDeserializer():(MBeanNotificationInfo.class.isAssignableFrom(cl)?new MBeanNotificationInfoDeserializer():null)))))));
   }
}
