package com.caucho.hessian.io;

import com.caucho.hessian.HessianException;
import com.caucho.hessian.io.AbstractStringValueDeserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class StringValueDeserializer extends AbstractStringValueDeserializer {

   private Class _cl;
   private Constructor _constructor;


   public StringValueDeserializer(Class cl) {
      try {
         this._cl = cl;
         this._constructor = cl.getConstructor(new Class[]{String.class});
      } catch (Exception var3) {
         throw new RuntimeException(var3);
      }
   }

   public Class getType() {
      return this._cl;
   }

   protected Object create(String value) throws IOException {
      if(value == null) {
         throw new IOException(this._cl.getName() + " expects name.");
      } else {
         try {
            return this._constructor.newInstance(new Object[]{value});
         } catch (Exception var3) {
            throw new HessianException(this._cl.getName() + ": value=" + value + "\n" + var3, var3);
         }
      }
   }
}
