package com.caucho.hessian.io;

import com.caucho.hessian.io.HessianHandle;
import java.io.Serializable;
import java.util.Locale;

public class LocaleHandle implements Serializable, HessianHandle {

   private String value;


   public LocaleHandle(String locale) {
      this.value = locale;
   }

   private Object readResolve() {
      String s = this.value;
      if(s == null) {
         return null;
      } else {
         int len = s.length();
         char ch = 32;

         int i;
         for(i = 0; i < len && (97 <= (ch = s.charAt(i)) && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57); ++i) {
            ;
         }

         String language = s.substring(0, i);
         String country = null;
         String var = null;
         int head;
         if(ch == 45 || ch == 95) {
            ++i;

            for(head = i; i < len && (97 <= (ch = s.charAt(i)) && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57); ++i) {
               ;
            }

            country = s.substring(head, i);
         }

         if(ch == 45 || ch == 95) {
            ++i;

            for(head = i; i < len && (97 <= (ch = s.charAt(i)) && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57); ++i) {
               ;
            }

            var = s.substring(head, i);
         }

         return var != null?new Locale(language, country, var):(country != null?new Locale(language, country):new Locale(language));
      }
   }
}
