package com.caucho.hessian.io;

import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class HessianSerializerOutput extends Hessian2Output {

   public HessianSerializerOutput(OutputStream os) {
      super(os);
   }

   public HessianSerializerOutput() {
      super((OutputStream)null);
   }

   public void writeObjectImpl(Object obj) throws IOException {
      Class cl = obj.getClass();

      try {
         Method var8 = cl.getMethod("writeReplace", new Class[0]);
         Object var9 = var8.invoke(obj, new Object[0]);
         this.writeObject(var9);
      } catch (Exception var7) {
         try {
            this.writeMapBegin(cl.getName());

            while(cl != null) {
               Field[] e = cl.getDeclaredFields();

               for(int i = 0; i < e.length; ++i) {
                  Field field = e[i];
                  if(!Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                     field.setAccessible(true);
                     this.writeString(field.getName());
                     this.writeObject(field.get(obj));
                  }
               }

               cl = cl.getSuperclass();
            }

            this.writeMapEnd();
         } catch (IllegalAccessException var6) {
            throw new IOExceptionWrapper(var6);
         }
      }
   }
}
