package com.caucho.hessian.io;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public class HessianSerializerInput extends Hessian2Input {

   public HessianSerializerInput(InputStream is) {
      super(is);
   }

   public HessianSerializerInput() {
      super((InputStream)null);
   }

   protected Object readObjectImpl(Class cl) throws IOException {
      try {
         Object e = cl.newInstance();
         if(this._refs == null) {
            this._refs = new ArrayList();
         }

         this._refs.add(e);
         HashMap fieldMap = this.getFieldMap(cl);

         int code;
         for(code = this.read(); code >= 0 && code != 122; code = this.read()) {
            this.unread();
            Object e1 = this.readObject();
            Field field = (Field)fieldMap.get(e1);
            Object value;
            if(field != null) {
               value = this.readObject(field.getType());
               field.set(e, value);
            } else {
               value = this.readObject();
            }
         }

         if(code != 122) {
            throw this.expect("map", code);
         } else {
            try {
               Method e2 = cl.getMethod("readResolve", new Class[0]);
               return e2.invoke(e, new Object[0]);
            } catch (Exception var8) {
               return e;
            }
         }
      } catch (IOException var9) {
         throw var9;
      } catch (Exception var10) {
         throw new IOExceptionWrapper(var10);
      }
   }

   protected HashMap getFieldMap(Class cl) {
      HashMap fieldMap;
      for(fieldMap = new HashMap(); cl != null; cl = cl.getSuperclass()) {
         Field[] fields = cl.getDeclaredFields();

         for(int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if(!Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
               field.setAccessible(true);
               fieldMap.put(field.getName(), field);
            }
         }
      }

      return fieldMap;
   }
}
