package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.HessianFactory;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class HessianInputFactory {

   public static final Logger log = Logger.getLogger(HessianInputFactory.class.getName());
   private HessianFactory _factory = new HessianFactory();


   public void setSerializerFactory(SerializerFactory factory) {
      this._factory.setSerializerFactory(factory);
   }

   public SerializerFactory getSerializerFactory() {
      return this._factory.getSerializerFactory();
   }

   public HessianInputFactory.HeaderType readHeader(InputStream is) throws IOException {
      int code = is.read();
      int major = is.read();
      int minor = is.read();
      switch(code) {
      case -1:
         throw new IOException("Unexpected end of file for Hessian message");
      case 72:
         return HessianInputFactory.HeaderType.HESSIAN_2;
      case 99:
         if(major >= 2) {
            return HessianInputFactory.HeaderType.CALL_1_REPLY_2;
         }

         return HessianInputFactory.HeaderType.CALL_1_REPLY_1;
      case 114:
         return HessianInputFactory.HeaderType.REPLY_1;
      default:
         throw new IOException((char)code + " 0x" + Integer.toHexString(code) + " is an unknown Hessian message code.");
      }
   }

   public AbstractHessianInput open(InputStream is) throws IOException {
      int code = is.read();
      int major = is.read();
      int minor = is.read();
      switch(code) {
      case 67:
      case 82:
      case 99:
      case 114:
         if(major >= 2) {
            return this._factory.createHessian2Input(is);
         }

         return this._factory.createHessianInput(is);
      default:
         throw new IOException((char)code + " is an unknown Hessian message code.");
      }
   }


   // $FF: synthetic class
   static class SyntheticClass_1 {

      // $FF: synthetic field
      static final int[] $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType = new int[HessianInputFactory.HeaderType.values().length];


      static {
         try {
            $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[HessianInputFactory.HeaderType.CALL_1_REPLY_1.ordinal()] = 1;
         } catch (NoSuchFieldError var3) {
            ;
         }

         try {
            $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[HessianInputFactory.HeaderType.CALL_1_REPLY_2.ordinal()] = 2;
         } catch (NoSuchFieldError var2) {
            ;
         }

         try {
            $SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[HessianInputFactory.HeaderType.HESSIAN_2.ordinal()] = 3;
         } catch (NoSuchFieldError var1) {
            ;
         }

      }
   }

   public static enum HeaderType {

      CALL_1_REPLY_1,
      CALL_1_REPLY_2,
      HESSIAN_2,
      REPLY_1,
      REPLY_2;
      // $FF: synthetic field
      private static final HessianInputFactory.HeaderType[] $VALUES = new HessianInputFactory.HeaderType[]{CALL_1_REPLY_1, CALL_1_REPLY_2, HESSIAN_2, REPLY_1, REPLY_2};


      public boolean isCall1() {
         switch(HessianInputFactory.SyntheticClass_1.$SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[this.ordinal()]) {
         case 1:
         case 2:
            return true;
         default:
            return false;
         }
      }

      public boolean isCall2() {
         switch(HessianInputFactory.SyntheticClass_1.$SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[this.ordinal()]) {
         case 3:
            return true;
         default:
            return false;
         }
      }

      public boolean isReply1() {
         switch(HessianInputFactory.SyntheticClass_1.$SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[this.ordinal()]) {
         case 1:
            return true;
         default:
            return false;
         }
      }

      public boolean isReply2() {
         switch(HessianInputFactory.SyntheticClass_1.$SwitchMap$com$caucho$hessian$io$HessianInputFactory$HeaderType[this.ordinal()]) {
         case 2:
         case 3:
            return true;
         default:
            return false;
         }
      }

   }
}
