package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanSerializer extends AbstractSerializer {

   private static final Logger log = Logger.getLogger(BeanSerializer.class.getName());
   private static final Object[] NULL_ARGS = new Object[0];
   private Method[] _methods;
   private String[] _names;
   private Object _writeReplaceFactory;
   private Method _writeReplace;


   public BeanSerializer(Class cl, ClassLoader loader) {
      this.introspectWriteReplace(cl, loader);
      ArrayList primitiveMethods = new ArrayList();

      ArrayList compoundMethods;
      int i;
      for(compoundMethods = new ArrayList(); cl != null; cl = cl.getSuperclass()) {
         Method[] methodList = cl.getDeclaredMethods();

         for(i = 0; i < methodList.length; ++i) {
            Method name = methodList[i];
            if(!Modifier.isStatic(name.getModifiers()) && name.getParameterTypes().length == 0) {
               String j = name.getName();
               if(j.startsWith("get")) {
                  Class type = name.getReturnType();
                  if(!type.equals(Void.TYPE) && this.findSetter(methodList, j, type) != null) {
                     name.setAccessible(true);
                     if(!type.isPrimitive() && (!type.getName().startsWith("java.lang.") || type.equals(Object.class))) {
                        compoundMethods.add(name);
                     } else {
                        primitiveMethods.add(name);
                     }
                  }
               }
            }
         }
      }

      ArrayList var10 = new ArrayList();
      var10.addAll(primitiveMethods);
      var10.addAll(compoundMethods);
      Collections.sort(var10, new BeanSerializer.MethodNameCmp());
      this._methods = new Method[var10.size()];
      var10.toArray(this._methods);
      this._names = new String[this._methods.length];

      for(i = 0; i < this._methods.length; ++i) {
         String var11 = this._methods[i].getName();
         var11 = var11.substring(3);

         int var12;
         for(var12 = 0; var12 < var11.length() && Character.isUpperCase(var11.charAt(var12)); ++var12) {
            ;
         }

         if(var12 == 1) {
            var11 = var11.substring(0, var12).toLowerCase(Locale.ENGLISH) + var11.substring(var12);
         } else if(var12 > 1) {
            var11 = var11.substring(0, var12 - 1).toLowerCase(Locale.ENGLISH) + var11.substring(var12 - 1);
         }

         this._names[i] = var11;
      }

   }

   private void introspectWriteReplace(Class cl, ClassLoader loader) {
      try {
         String e = cl.getName() + "HessianSerializer";
         Class serializerClass = Class.forName(e, false, loader);
         Object serializerObject = serializerClass.newInstance();
         Method writeReplace = this.getWriteReplace(serializerClass, cl);
         if(writeReplace != null) {
            this._writeReplaceFactory = serializerObject;
            this._writeReplace = writeReplace;
            return;
         }
      } catch (ClassNotFoundException var7) {
         ;
      } catch (Exception var8) {
         log.log(Level.FINER, var8.toString(), var8);
      }

      this._writeReplace = this.getWriteReplace(cl);
   }

   protected Method getWriteReplace(Class cl) {
      while(cl != null) {
         Method[] methods = cl.getDeclaredMethods();

         for(int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if(method.getName().equals("writeReplace") && method.getParameterTypes().length == 0) {
               return method;
            }
         }

         cl = cl.getSuperclass();
      }

      return null;
   }

   protected Method getWriteReplace(Class cl, Class param) {
      while(cl != null) {
         Method[] arr$ = cl.getDeclaredMethods();
         int len$ = arr$.length;

         for(int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if(method.getName().equals("writeReplace") && method.getParameterTypes().length == 1 && param.equals(method.getParameterTypes()[0])) {
               return method;
            }
         }

         cl = cl.getSuperclass();
      }

      return null;
   }

   public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
      if(!out.addRef(obj)) {
         Class cl = obj.getClass();

         try {
            if(this._writeReplace != null) {
               Object var12;
               if(this._writeReplaceFactory != null) {
                  var12 = this._writeReplace.invoke(this._writeReplaceFactory, new Object[]{obj});
               } else {
                  var12 = this._writeReplace.invoke(obj, new Object[0]);
               }

               out.writeObject(var12);
               out.replaceRef(var12, obj);
               return;
            }
         } catch (Exception var11) {
            log.log(Level.FINER, var11.toString(), var11);
         }

         int ref = out.writeObjectBegin(cl.getName());
         Method var10000;
         int i;
         Object value;
         if(ref < -1) {
            for(i = 0; i < this._methods.length; ++i) {
               var10000 = this._methods[i];
               value = null;

               try {
                  value = this._methods[i].invoke(obj, (Object[])null);
               } catch (Exception var10) {
                  log.log(Level.FINE, var10.toString(), var10);
               }

               out.writeString(this._names[i]);
               out.writeObject(value);
            }

            out.writeMapEnd();
         } else {
            if(ref == -1) {
               out.writeInt(this._names.length);

               for(i = 0; i < this._names.length; ++i) {
                  out.writeString(this._names[i]);
               }

               out.writeObjectBegin(cl.getName());
            }

            for(i = 0; i < this._methods.length; ++i) {
               var10000 = this._methods[i];
               value = null;

               try {
                  value = this._methods[i].invoke(obj, (Object[])null);
               } catch (Exception var9) {
                  log.log(Level.FINER, var9.toString(), var9);
               }

               out.writeObject(value);
            }
         }

      }
   }

   private Method findSetter(Method[] methods, String getterName, Class arg) {
      String setterName = "set" + getterName.substring(3);

      for(int i = 0; i < methods.length; ++i) {
         Method method = methods[i];
         if(method.getName().equals(setterName) && method.getReturnType().equals(Void.TYPE)) {
            Class[] params = method.getParameterTypes();
            if(params.length == 1 && params[0].equals(arg)) {
               return method;
            }
         }
      }

      return null;
   }


   static class MethodNameCmp implements Comparator {

      public int compare(Method a, Method b) {
         return a.getName().compareTo(b.getName());
      }
   }
}
