package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractMapDeserializer;
import com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;

public class BeanDeserializer extends AbstractMapDeserializer {

   private Class _type;
   private HashMap _methodMap;
   private Method _readResolve;
   private Constructor _constructor;
   private Object[] _constructorArgs;


   public BeanDeserializer(Class cl) {
      this._type = cl;
      this._methodMap = this.getMethodMap(cl);
      this._readResolve = this.getReadResolve(cl);
      Constructor[] constructors = cl.getConstructors();
      int bestLength = Integer.MAX_VALUE;

      for(int params = 0; params < constructors.length; ++params) {
         if(constructors[params].getParameterTypes().length < bestLength) {
            this._constructor = constructors[params];
            bestLength = this._constructor.getParameterTypes().length;
         }
      }

      if(this._constructor != null) {
         this._constructor.setAccessible(true);
         Class[] var6 = this._constructor.getParameterTypes();
         this._constructorArgs = new Object[var6.length];

         for(int i = 0; i < var6.length; ++i) {
            this._constructorArgs[i] = getParamArg(var6[i]);
         }
      }

   }

   public Class getType() {
      return this._type;
   }

   public Object readMap(AbstractHessianInput in) throws IOException {
      try {
         Object e = this.instantiate();
         return this.readMap(in, e);
      } catch (IOException var3) {
         throw var3;
      } catch (Exception var4) {
         throw new IOExceptionWrapper(var4);
      }
   }

   public Object readMap(AbstractHessianInput in, Object obj) throws IOException {
      try {
         int e = in.addRef(obj);

         Object resolve;
         while(!in.isEnd()) {
            resolve = in.readObject();
            Method method = (Method)this._methodMap.get(resolve);
            Object value;
            if(method != null) {
               value = in.readObject(method.getParameterTypes()[0]);
               method.invoke(obj, new Object[]{value});
            } else {
               value = in.readObject();
            }
         }

         in.readMapEnd();
         resolve = this.resolve(obj);
         if(obj != resolve) {
            in.setRef(e, resolve);
         }

         return resolve;
      } catch (IOException var7) {
         throw var7;
      } catch (Exception var8) {
         throw new IOExceptionWrapper(var8);
      }
   }

   private Object resolve(Object obj) {
      try {
         if(this._readResolve != null) {
            return this._readResolve.invoke(obj, new Object[0]);
         }
      } catch (Exception var3) {
         ;
      }

      return obj;
   }

   protected Object instantiate() throws Exception {
      return this._constructor.newInstance(this._constructorArgs);
   }

   protected Method getReadResolve(Class cl) {
      while(cl != null) {
         Method[] methods = cl.getDeclaredMethods();

         for(int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if(method.getName().equals("readResolve") && method.getParameterTypes().length == 0) {
               return method;
            }
         }

         cl = cl.getSuperclass();
      }

      return null;
   }

   protected HashMap getMethodMap(Class cl) {
      HashMap methodMap;
      for(methodMap = new HashMap(); cl != null; cl = cl.getSuperclass()) {
         Method[] methods = cl.getDeclaredMethods();

         for(int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if(!Modifier.isStatic(method.getModifiers())) {
               String name = method.getName();
               if(name.startsWith("set")) {
                  Class[] paramTypes = method.getParameterTypes();
                  if(paramTypes.length == 1 && method.getReturnType().equals(Void.TYPE) && this.findGetter(methods, name, paramTypes[0]) != null) {
                     try {
                        method.setAccessible(true);
                     } catch (Throwable var9) {
                        var9.printStackTrace();
                     }

                     name = name.substring(3);

                     int j;
                     for(j = 0; j < name.length() && Character.isUpperCase(name.charAt(j)); ++j) {
                        ;
                     }

                     if(j == 1) {
                        name = name.substring(0, j).toLowerCase(Locale.ENGLISH) + name.substring(j);
                     } else if(j > 1) {
                        name = name.substring(0, j - 1).toLowerCase(Locale.ENGLISH) + name.substring(j - 1);
                     }

                     methodMap.put(name, method);
                  }
               }
            }
         }
      }

      return methodMap;
   }

   private Method findGetter(Method[] methods, String setterName, Class arg) {
      String getterName = "get" + setterName.substring(3);

      for(int i = 0; i < methods.length; ++i) {
         Method method = methods[i];
         if(method.getName().equals(getterName) && method.getReturnType().equals(arg)) {
            Class[] params = method.getParameterTypes();
            if(params.length == 0) {
               return method;
            }
         }
      }

      return null;
   }

   protected static Object getParamArg(Class cl) {
      if(!cl.isPrimitive()) {
         return null;
      } else if(Boolean.TYPE.equals(cl)) {
         return Boolean.FALSE;
      } else if(Byte.TYPE.equals(cl)) {
         return Byte.valueOf((byte)0);
      } else if(Short.TYPE.equals(cl)) {
         return Short.valueOf((short)0);
      } else if(Character.TYPE.equals(cl)) {
         return Character.valueOf('\u0000');
      } else if(Integer.TYPE.equals(cl)) {
         return Integer.valueOf(0);
      } else if(Long.TYPE.equals(cl)) {
         return Long.valueOf(0L);
      } else if(Float.TYPE.equals(cl)) {
         return Double.valueOf(0.0D);
      } else if(Double.TYPE.equals(cl)) {
         return Double.valueOf(0.0D);
      } else {
         throw new UnsupportedOperationException();
      }
   }
}
