package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;

public abstract class AbstractStringValueDeserializer extends AbstractDeserializer {

   protected abstract Object create(String var1) throws IOException;

   public Object readMap(AbstractHessianInput in) throws IOException {
      String value = null;

      while(!in.isEnd()) {
         String object = in.readString();
         if(object.equals("value")) {
            value = in.readString();
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();
      Object object1 = this.create(value);
      in.addRef(object1);
      return object1;
   }

   public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
      String[] fieldNames = (String[])((String[])fields);
      String value = null;

      for(int object = 0; object < fieldNames.length; ++object) {
         if("value".equals(fieldNames[object])) {
            value = in.readString();
         } else {
            in.readObject();
         }
      }

      Object var6 = this.create(value);
      in.addRef(var6);
      return var6;
   }
}
