package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.IOException;

public abstract class AbstractStreamDeserializer extends AbstractDeserializer {

   public abstract Class getType();

   public Object readMap(AbstractHessianInput in) throws IOException {
      Object value = null;

      while(!in.isEnd()) {
         String key = in.readString();
         if(key.equals("value")) {
            value = this.readStreamValue(in);
         } else {
            in.readObject();
         }
      }

      in.readMapEnd();
      return value;
   }

   public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
      String[] fieldNames = (String[])((String[])fields);
      Object value = null;

      for(int i = 0; i < fieldNames.length; ++i) {
         if("value".equals(fieldNames[i])) {
            value = this.readStreamValue(in);
            in.addRef(value);
         } else {
            in.readObject();
         }
      }

      return value;
   }

   protected abstract Object readStreamValue(AbstractHessianInput var1) throws IOException;
}
