package com.caucho.hessian.client;

import com.caucho.hessian.client.AbstractHessianConnection;
import com.caucho.hessian.client.HessianConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class HessianURLConnection extends AbstractHessianConnection {

   private URL _url;
   private URLConnection _conn;
   private int _statusCode;
   private String _statusMessage;
   private InputStream _inputStream;
   private InputStream _errorStream;


   HessianURLConnection(URL url, URLConnection conn) {
      this._url = url;
      this._conn = conn;
   }

   public void addHeader(String key, String value) {
      this._conn.setRequestProperty(key, value);
   }

   public OutputStream getOutputStream() throws IOException {
      return this._conn.getOutputStream();
   }

   public void sendRequest() throws IOException {
      if(this._conn instanceof HttpURLConnection) {
         HttpURLConnection httpConn = (HttpURLConnection)this._conn;
         this._statusCode = 500;

         try {
            this._statusCode = httpConn.getResponseCode();
         } catch (Exception var6) {
            ;
         }

         this.parseResponseHeaders(httpConn);
         InputStream is = null;
         if(this._statusCode != 200) {
            StringBuffer sb = new StringBuffer();

            try {
               is = httpConn.getInputStream();
               int ch;
               if(is != null) {
                  while((ch = is.read()) >= 0) {
                     sb.append((char)ch);
                  }

                  is.close();
               }

               is = httpConn.getErrorStream();
               if(is != null) {
                  while((ch = is.read()) >= 0) {
                     sb.append((char)ch);
                  }
               }

               this._statusMessage = sb.toString();
            } catch (FileNotFoundException var7) {
               throw new HessianConnectionException("HessianProxy cannot connect to \'" + this._url, var7);
            } catch (IOException var8) {
               if(is == null) {
                  throw new HessianConnectionException(this._statusCode + ": " + var8, var8);
               }

               throw new HessianConnectionException(this._statusCode + ": " + sb, var8);
            }

            if(is != null) {
               is.close();
            }

            throw new HessianConnectionException(this._statusCode + ": " + sb.toString());
         }
      }

   }

   protected void parseResponseHeaders(HttpURLConnection conn) throws IOException {
   }

   public int getStatusCode() {
      return this._statusCode;
   }

   public String getStatusMessage() {
      return this._statusMessage;
   }

   public InputStream getInputStream() throws IOException {
      return this._conn.getInputStream();
   }

   public String getContentEncoding() {
      return this._conn.getContentEncoding();
   }

   public void close() {
      this._inputStream = null;
   }

   public void destroy() {
      this.close();
      URLConnection conn = this._conn;
      this._conn = null;
      if(conn instanceof HttpURLConnection) {
         ((HttpURLConnection)conn).disconnect();
      }

   }
}
