package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianMetaInfoAPI;
import com.caucho.hessian.client.HessianProxy;
import com.caucho.hessian.client.HessianProxyResolver;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.client.HessianURLConnectionFactory;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.services.client.ServiceProxyFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class HessianProxyFactory implements ServiceProxyFactory, ObjectFactory {

   protected static Logger log = Logger.getLogger(HessianProxyFactory.class.getName());
   private final ClassLoader _loader;
   private SerializerFactory _serializerFactory;
   private HessianConnectionFactory _connFactory;
   private HessianRemoteResolver _resolver;
   private String _user;
   private String _password;
   private String _basicAuth;
   private boolean _isOverloadEnabled;
   private boolean _isHessian2Reply;
   private boolean _isHessian2Request;
   private boolean _isChunkedPost;
   private boolean _isDebug;
   private long _readTimeout;
   private long _connectTimeout;


   public HessianProxyFactory() {
      this(Thread.currentThread().getContextClassLoader());
   }

   public HessianProxyFactory(ClassLoader loader) {
      this._isOverloadEnabled = false;
      this._isHessian2Reply = true;
      this._isHessian2Request = false;
      this._isChunkedPost = true;
      this._isDebug = false;
      this._readTimeout = -1L;
      this._connectTimeout = -1L;
      this._loader = loader;
      this._resolver = new HessianProxyResolver(this);
   }

   public void setUser(String user) {
      this._user = user;
      this._basicAuth = null;
   }

   public void setPassword(String password) {
      this._password = password;
      this._basicAuth = null;
   }

   public String getBasicAuth() {
      return this._basicAuth != null?this._basicAuth:(this._user != null && this._password != null?"Basic " + this.base64(this._user + ":" + this._password):null);
   }

   public void setConnectionFactory(HessianConnectionFactory factory) {
      this._connFactory = factory;
   }

   public HessianConnectionFactory getConnectionFactory() {
      if(this._connFactory == null) {
         this._connFactory = this.createHessianConnectionFactory();
         this._connFactory.setHessianProxyFactory(this);
      }

      return this._connFactory;
   }

   public void setDebug(boolean isDebug) {
      this._isDebug = isDebug;
   }

   public boolean isDebug() {
      return this._isDebug;
   }

   public boolean isOverloadEnabled() {
      return this._isOverloadEnabled;
   }

   public void setOverloadEnabled(boolean isOverloadEnabled) {
      this._isOverloadEnabled = isOverloadEnabled;
   }

   public void setChunkedPost(boolean isChunked) {
      this._isChunkedPost = isChunked;
   }

   public boolean isChunkedPost() {
      return this._isChunkedPost;
   }

   public long getReadTimeout() {
      return this._readTimeout;
   }

   public void setReadTimeout(long timeout) {
      this._readTimeout = timeout;
   }

   public long getConnectTimeout() {
      return this._connectTimeout;
   }

   public void setConnectTimeout(long timeout) {
      this._connectTimeout = timeout;
   }

   public void setHessian2Reply(boolean isHessian2) {
      this._isHessian2Reply = isHessian2;
   }

   public void setHessian2Request(boolean isHessian2) {
      this._isHessian2Request = isHessian2;
      if(isHessian2) {
         this._isHessian2Reply = true;
      }

   }

   public HessianRemoteResolver getRemoteResolver() {
      return this._resolver;
   }

   public void setSerializerFactory(SerializerFactory factory) {
      this._serializerFactory = factory;
   }

   public SerializerFactory getSerializerFactory() {
      if(this._serializerFactory == null) {
         this._serializerFactory = new SerializerFactory(this._loader);
      }

      return this._serializerFactory;
   }

   protected HessianConnectionFactory createHessianConnectionFactory() {
      String className = System.getProperty(HessianConnectionFactory.class.getName());
      HessianConnectionFactory factory = null;

      try {
         if(className != null) {
            ClassLoader e = Thread.currentThread().getContextClassLoader();
            Class cl = Class.forName(className, false, e);
            factory = (HessianConnectionFactory)cl.newInstance();
            return factory;
         }
      } catch (Exception var5) {
         throw new RuntimeException(var5);
      }

      return new HessianURLConnectionFactory();
   }

   public Object create(String url) throws MalformedURLException, ClassNotFoundException {
      HessianMetaInfoAPI metaInfo = (HessianMetaInfoAPI)this.create(HessianMetaInfoAPI.class, url);
      String apiClassName = (String)metaInfo._hessian_getAttribute("java.api.class");
      if(apiClassName == null) {
         throw new HessianRuntimeException(url + " has an unknown api.");
      } else {
         Class apiClass = Class.forName(apiClassName, false, this._loader);
         return this.create(apiClass, url);
      }
   }

   public Object create(Class api, String urlName) throws MalformedURLException {
      return this.create(api, (String)urlName, this._loader);
   }

   public Object create(Class api, String urlName, ClassLoader loader) throws MalformedURLException {
      URL url = new URL(urlName);
      return this.create(api, (URL)url, loader);
   }

   public Object create(Class api, URL url, ClassLoader loader) {
      if(api == null) {
         throw new NullPointerException("api must not be null for HessianProxyFactory.create()");
      } else {
         HessianProxy handler = null;
         handler = new HessianProxy(url, this, api);
         return Proxy.newProxyInstance(loader, new Class[]{api, HessianRemoteObject.class}, handler);
      }
   }

   public AbstractHessianInput getHessianInput(InputStream is) {
      return this.getHessian2Input(is);
   }

   public AbstractHessianInput getHessian1Input(InputStream is) {
      if(this._isDebug) {
         is = new HessianDebugInputStream((InputStream)is, new PrintWriter(System.out));
      }

      HessianInput in = new HessianInput((InputStream)is);
      in.setRemoteResolver(this.getRemoteResolver());
      in.setSerializerFactory(this.getSerializerFactory());
      return in;
   }

   public AbstractHessianInput getHessian2Input(InputStream is) {
      if(this._isDebug) {
         is = new HessianDebugInputStream((InputStream)is, new PrintWriter(System.out));
      }

      Hessian2Input in = new Hessian2Input((InputStream)is);
      in.setRemoteResolver(this.getRemoteResolver());
      in.setSerializerFactory(this.getSerializerFactory());
      return in;
   }

   public AbstractHessianOutput getHessianOutput(OutputStream os) {
      Object out;
      if(this._isHessian2Request) {
         out = new Hessian2Output(os);
      } else {
         HessianOutput out1 = new HessianOutput(os);
         out = out1;
         if(this._isHessian2Reply) {
            out1.setVersion(2);
         }
      }

      ((AbstractHessianOutput)out).setSerializerFactory(this.getSerializerFactory());
      return (AbstractHessianOutput)out;
   }

   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
      Reference ref = (Reference)obj;
      String api = null;
      String url = null;

      for(int apiClass = 0; apiClass < ref.size(); ++apiClass) {
         RefAddr addr = ref.get(apiClass);
         String type = addr.getType();
         String value = (String)addr.getContent();
         if(type.equals("type")) {
            api = value;
         } else if(type.equals("url")) {
            url = value;
         } else if(type.equals("user")) {
            this.setUser(value);
         } else if(type.equals("password")) {
            this.setPassword(value);
         }
      }

      if(url == null) {
         throw new NamingException("`url\' must be configured for HessianProxyFactory.");
      } else if(api == null) {
         throw new NamingException("`type\' must be configured for HessianProxyFactory.");
      } else {
         Class var12 = Class.forName(api, false, this._loader);
         return this.create(var12, url);
      }
   }

   private String base64(String value) {
      StringBuffer cb = new StringBuffer();
      boolean i = false;

      long chunk;
      int i1;
      for(i1 = 0; i1 + 2 < value.length(); i1 += 3) {
         chunk = (long)value.charAt(i1);
         chunk = (chunk << 8) + (long)value.charAt(i1 + 1);
         chunk = (chunk << 8) + (long)value.charAt(i1 + 2);
         cb.append(encode(chunk >> 18));
         cb.append(encode(chunk >> 12));
         cb.append(encode(chunk >> 6));
         cb.append(encode(chunk));
      }

      if(i1 + 1 < value.length()) {
         chunk = (long)value.charAt(i1);
         chunk = (chunk << 8) + (long)value.charAt(i1 + 1);
         chunk <<= 8;
         cb.append(encode(chunk >> 18));
         cb.append(encode(chunk >> 12));
         cb.append(encode(chunk >> 6));
         cb.append('=');
      } else if(i1 < value.length()) {
         chunk = (long)value.charAt(i1);
         chunk <<= 16;
         cb.append(encode(chunk >> 18));
         cb.append(encode(chunk >> 12));
         cb.append('=');
         cb.append('=');
      }

      return cb.toString();
   }

   public static char encode(long d) {
      d &= 63L;
      return (char)(d < 26L?(char)((int)(d + 65L)):(d < 52L?(char)((int)(d + 97L - 26L)):(d < 62L?(char)((int)(d + 48L - 52L)):(d == 62L?'+':'/'))));
   }

}
