package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianConnection;
import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemote;
import com.caucho.services.server.AbstractSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class HessianProxy implements InvocationHandler, Serializable {

   private static final Logger log = Logger.getLogger(HessianProxy.class.getName());
   protected HessianProxyFactory _factory;
   private WeakHashMap _mangleMap;
   private Class _type;
   private URL _url;


   protected HessianProxy(URL url, HessianProxyFactory factory) {
      this(url, factory, (Class)null);
   }

   protected HessianProxy(URL url, HessianProxyFactory factory, Class type) {
      this._mangleMap = new WeakHashMap();
      this._factory = factory;
      this._url = url;
      this._type = type;
   }

   public URL getURL() {
      return this._url;
   }

   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
      WeakHashMap is = this._mangleMap;
      String mangleName;
      synchronized(this._mangleMap) {
         mangleName = (String)this._mangleMap.get(method);
      }

      if(mangleName == null) {
         String is1 = method.getName();
         Class[] conn = method.getParameterTypes();
         if(is1.equals("equals") && conn.length == 1 && conn[0].equals(Object.class)) {
            Object e3 = args[0];
            if(e3 != null && Proxy.isProxyClass(e3.getClass())) {
               InvocationHandler code2 = Proxy.getInvocationHandler(e3);
               if(!(code2 instanceof HessianProxy)) {
                  return Boolean.FALSE;
               }

               HessianProxy major1 = (HessianProxy)code2;
               return new Boolean(this._url.equals(major1.getURL()));
            }

            return Boolean.FALSE;
         }

         if(is1.equals("hashCode") && conn.length == 0) {
            return new Integer(this._url.hashCode());
         }

         if(is1.equals("getHessianType")) {
            return proxy.getClass().getInterfaces()[0].getName();
         }

         if(is1.equals("getHessianURL")) {
            return this._url.toString();
         }

         if(is1.equals("toString") && conn.length == 0) {
            return "HessianProxy[" + this._url + "]";
         }

         if(!this._factory.isOverloadEnabled()) {
            mangleName = method.getName();
         } else {
            mangleName = this.mangleName(method);
         }

         WeakHashMap e = this._mangleMap;
         synchronized(this._mangleMap) {
            this._mangleMap.put(method, mangleName);
         }
      }

      Object is2 = null;
      HessianConnection conn1 = null;

      Object var12;
      try {
         if(log.isLoggable(Level.FINER)) {
            log.finer("Hessian[" + this._url + "] calling " + mangleName);
         }

         conn1 = this.sendRequest(mangleName, args);
         is2 = this.getInputStream(conn1);
         if(log.isLoggable(Level.FINEST)) {
            PrintWriter e1 = new PrintWriter(new HessianProxy.LogWriter(log));
            HessianDebugInputStream code = new HessianDebugInputStream((InputStream)is2, e1);
            code.startTop2();
            is2 = code;
         }

         int code1 = ((InputStream)is2).read();
         int major;
         int minor;
         Object value;
         AbstractHessianInput e2;
         if(code1 == 72) {
            major = ((InputStream)is2).read();
            minor = ((InputStream)is2).read();
            e2 = this._factory.getHessian2Input((InputStream)is2);
            value = e2.readReply(method.getReturnType());
            var12 = value;
            return var12;
         }

         if(code1 != 114) {
            throw new HessianProtocolException("\'" + (char)code1 + "\' is an unknown code");
         }

         major = ((InputStream)is2).read();
         minor = ((InputStream)is2).read();
         e2 = this._factory.getHessianInput((InputStream)is2);
         e2.startReplyBody();
         value = e2.readObject(method.getReturnType());
         if(value instanceof InputStream) {
            value = new HessianProxy.ResultInputStream(conn1, (InputStream)is2, e2, (InputStream)value);
            is2 = null;
            conn1 = null;
         } else {
            e2.completeReply();
         }

         var12 = value;
      } catch (HessianProtocolException var30) {
         throw new HessianRuntimeException(var30);
      } finally {
         try {
            if(is2 != null) {
               ((InputStream)is2).close();
            }
         } catch (Exception var27) {
            log.log(Level.FINE, var27.toString(), var27);
         }

         try {
            if(conn1 != null) {
               conn1.destroy();
            }
         } catch (Exception var26) {
            log.log(Level.FINE, var26.toString(), var26);
         }

      }

      return var12;
   }

   protected InputStream getInputStream(HessianConnection conn) throws IOException {
      Object is = conn.getInputStream();
      if("deflate".equals(conn.getContentEncoding())) {
         is = new InflaterInputStream((InputStream)is, new Inflater(true));
      }

      return (InputStream)is;
   }

   protected String mangleName(Method method) {
      Class[] param = method.getParameterTypes();
      return param != null && param.length != 0?AbstractSkeleton.mangleName(method, false):method.getName();
   }

   protected HessianConnection sendRequest(String methodName, Object[] args) throws IOException {
      HessianConnection conn = null;
      conn = this._factory.getConnectionFactory().open(this._url);
      boolean isValid = false;

      HessianConnection dOs1;
      try {
         this.addRequestHeaders(conn);
         Object os = null;

         try {
            os = conn.getOutputStream();
         } catch (Exception var11) {
            throw new HessianRuntimeException(var11);
         }

         if(log.isLoggable(Level.FINEST)) {
            PrintWriter out = new PrintWriter(new HessianProxy.LogWriter(log));
            HessianDebugOutputStream dOs = new HessianDebugOutputStream((OutputStream)os, out);
            dOs.startTop2();
            os = dOs;
         }

         AbstractHessianOutput out1 = this._factory.getHessianOutput((OutputStream)os);
         out1.call(methodName, args);
         out1.flush();
         conn.sendRequest();
         isValid = true;
         dOs1 = conn;
      } finally {
         if(!isValid && conn != null) {
            conn.destroy();
         }

      }

      return dOs1;
   }

   protected void addRequestHeaders(HessianConnection conn) {
      conn.addHeader("Content-Type", "x-application/hessian");
      conn.addHeader("Accept-Encoding", "deflate");
      String basicAuth = this._factory.getBasicAuth();
      if(basicAuth != null) {
         conn.addHeader("Authorization", basicAuth);
      }

   }

   protected void parseResponseHeaders(URLConnection conn) {
   }

   public Object writeReplace() {
      return new HessianRemote(this._type.getName(), this._url.toString());
   }


   static class LogWriter extends Writer {

      private Logger _log;
      private Level _level;
      private StringBuilder _sb;


      LogWriter(Logger log) {
         this._level = Level.FINEST;
         this._sb = new StringBuilder();
         this._log = log;
      }

      public void write(char ch) {
         if(ch == 10 && this._sb.length() > 0) {
            this._log.fine(this._sb.toString());
            this._sb.setLength(0);
         } else {
            this._sb.append(ch);
         }

      }

      public void write(char[] buffer, int offset, int length) {
         for(int i = 0; i < length; ++i) {
            char ch = buffer[offset + i];
            if(ch == 10 && this._sb.length() > 0) {
               this._log.log(this._level, this._sb.toString());
               this._sb.setLength(0);
            } else {
               this._sb.append(ch);
            }
         }

      }

      public void flush() {
      }

      public void close() {
         if(this._sb.length() > 0) {
            this._log.log(this._level, this._sb.toString());
         }

      }
   }

   static class ResultInputStream extends InputStream {

      private HessianConnection _conn;
      private InputStream _connIs;
      private AbstractHessianInput _in;
      private InputStream _hessianIs;


      ResultInputStream(HessianConnection conn, InputStream is, AbstractHessianInput in, InputStream hessianIs) {
         this._conn = conn;
         this._connIs = is;
         this._in = in;
         this._hessianIs = hessianIs;
      }

      public int read() throws IOException {
         if(this._hessianIs != null) {
            int value = this._hessianIs.read();
            if(value < 0) {
               this.close();
            }

            return value;
         } else {
            return -1;
         }
      }

      public int read(byte[] buffer, int offset, int length) throws IOException {
         if(this._hessianIs != null) {
            int value = this._hessianIs.read(buffer, offset, length);
            if(value < 0) {
               this.close();
            }

            return value;
         } else {
            return -1;
         }
      }

      public void close() throws IOException {
         HessianConnection conn = this._conn;
         this._conn = null;
         InputStream connIs = this._connIs;
         this._connIs = null;
         AbstractHessianInput in = this._in;
         this._in = null;
         InputStream hessianIs = this._hessianIs;
         this._hessianIs = null;

         try {
            if(hessianIs != null) {
               hessianIs.close();
            }
         } catch (Exception var9) {
            HessianProxy.log.log(Level.FINE, var9.toString(), var9);
         }

         try {
            if(in != null) {
               in.completeReply();
               in.close();
            }
         } catch (Exception var8) {
            HessianProxy.log.log(Level.FINE, var8.toString(), var8);
         }

         try {
            if(connIs != null) {
               connIs.close();
            }
         } catch (Exception var7) {
            HessianProxy.log.log(Level.FINE, var7.toString(), var7);
         }

         try {
            if(conn != null) {
               conn.close();
            }
         } catch (Exception var6) {
            HessianProxy.log.log(Level.FINE, var6.toString(), var6);
         }

      }
   }
}
