package com.caucho.burlap.server;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.services.server.AbstractSkeleton;
import com.caucho.services.server.ServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BurlapSkeleton extends AbstractSkeleton {

   private static final Logger log = Logger.getLogger(BurlapSkeleton.class.getName());
   private Object _service;


   public BurlapSkeleton(Object service, Class apiClass) {
      super(apiClass);
      this._service = service;
   }

   public BurlapSkeleton(Class apiClass) {
      super(apiClass);
   }

   public void invoke(BurlapInput in, BurlapOutput out) throws Exception {
      this.invoke(this._service, in, out);
   }

   public void invoke(Object service, BurlapInput in, BurlapOutput out) throws Exception {
      in.readCall();
      ServiceContext context = ServiceContext.getContext();

      String header;
      while((header = in.readHeader()) != null) {
         Object methodName = in.readObject();
         context.addHeader(header, methodName);
      }

      String var13 = in.readMethod();
      Method method = this.getMethod(var13);
      if(log.isLoggable(Level.FINE)) {
         log.fine(this + " invoking " + var13 + " (" + method + ")");
      }

      if(method == null) {
         if("_burlap_getAttribute".equals(in.getMethod())) {
            String var14 = in.readString();
            in.completeCall();
            String var15 = null;
            if("java.api.class".equals(var14)) {
               var15 = this.getAPIClassName();
            } else if("java.home.class".equals(var14)) {
               var15 = this.getHomeClassName();
            } else if("java.object.class".equals(var14)) {
               var15 = this.getObjectClassName();
            }

            out.startReply();
            out.writeObject(var15);
            out.completeReply();
            return;
         }

         if(method == null) {
            out.startReply();
            out.writeFault("NoSuchMethodException", "The service has no method named: " + in.getMethod(), (Object)null);
            out.completeReply();
            return;
         }
      }

      Class[] args = method.getParameterTypes();
      Object[] values = new Object[args.length];

      for(int result = 0; result < args.length; ++result) {
         values[result] = in.readObject(args[result]);
      }

      in.completeCall();
      Object var16 = null;

      try {
         var16 = method.invoke(service, values);
      } catch (Throwable var12) {
         Throwable e = var12;
         log.log(Level.FINE, service + "." + method.getName() + "() failed with exception:\n" + var12.toString(), var12);
         if(var12 instanceof InvocationTargetException && var12.getCause() instanceof Exception) {
            e = ((InvocationTargetException)var12).getTargetException();
         }

         out.startReply();
         out.writeFault("ServiceException", e.getMessage(), e);
         out.completeReply();
         return;
      }

      out.startReply();
      out.writeObject(var16);
      out.completeReply();
   }

}
