package com.caucho.burlap.server;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.burlap.server.BurlapSkeleton;
import com.caucho.services.server.Service;
import com.caucho.services.server.ServiceContext;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BurlapServlet extends GenericServlet {

   private Class _apiClass;
   private Object _service;
   private BurlapSkeleton _skeleton;


   public String getServletInfo() {
      return "Burlap Servlet";
   }

   public void setService(Object service) {
      this._service = service;
   }

   public void setAPIClass(Class apiClass) {
      this._apiClass = apiClass;
   }

   public void init(ServletConfig config) throws ServletException {
      super.init(config);

      try {
         String e;
         if(this._service == null) {
            e = this.getInitParameter("service-class");
            Class loader = null;
            if(e != null) {
               ClassLoader loader1 = Thread.currentThread().getContextClassLoader();
               if(loader1 != null) {
                  loader = Class.forName(e, false, loader1);
               } else {
                  loader = Class.forName(e);
               }
            } else {
               if(this.getClass().equals(BurlapServlet.class)) {
                  throw new ServletException("server must extend BurlapServlet");
               }

               loader = this.getClass();
            }

            this._service = loader.newInstance();
            if(this._service instanceof BurlapServlet) {
               ((BurlapServlet)this._service).setService(this);
            }

            if(this._service instanceof Service) {
               ((Service)this._service).init(this.getServletConfig());
            } else if(this._service instanceof Servlet) {
               ((Servlet)this._service).init(this.getServletConfig());
            }
         }

         if(this._apiClass == null) {
            e = this.getInitParameter("api-class");
            if(e != null) {
               ClassLoader loader2 = Thread.currentThread().getContextClassLoader();
               if(loader2 != null) {
                  this._apiClass = Class.forName(e, false, loader2);
               } else {
                  this._apiClass = Class.forName(e);
               }
            } else {
               this._apiClass = this._service.getClass();
            }
         }

         this._skeleton = new BurlapSkeleton(this._service, this._apiClass);
      } catch (ServletException var5) {
         throw var5;
      } catch (Exception var6) {
         throw new ServletException(var6);
      }
   }

   public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
      HttpServletRequest req = (HttpServletRequest)request;
      HttpServletResponse res = (HttpServletResponse)response;
      if(!req.getMethod().equals("POST")) {
         res.setStatus(500, "Burlap Requires POST");
         PrintWriter serviceId1 = res.getWriter();
         res.setContentType("text/html");
         serviceId1.println("<h1>Burlap Requires POST</h1>");
      } else {
         String serviceId = req.getPathInfo();
         String objectId = req.getParameter("id");
         if(objectId == null) {
            objectId = req.getParameter("ejbid");
         }

         ServiceContext.begin(req, res, serviceId, objectId);

         try {
            ServletInputStream e = request.getInputStream();
            ServletOutputStream os = response.getOutputStream();
            BurlapInput in = new BurlapInput(e);
            BurlapOutput out = new BurlapOutput(os);
            this._skeleton.invoke(in, out);
         } catch (RuntimeException var16) {
            throw var16;
         } catch (ServletException var17) {
            throw var17;
         } catch (Throwable var18) {
            throw new ServletException(var18);
         } finally {
            ServiceContext.end();
         }

      }
   }
}
