package com.caucho.burlap.io;

import com.caucho.burlap.io.AbstractBurlapInput;
import com.caucho.burlap.io.BurlapProtocolException;
import com.caucho.burlap.io.BurlapRemote;
import com.caucho.burlap.io.BurlapServiceException;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class BurlapInput extends AbstractBurlapInput {

   private static int[] base64Decode;
   public static final int TAG_EOF = -1;
   public static final int TAG_NULL = 0;
   public static final int TAG_BOOLEAN = 1;
   public static final int TAG_INT = 2;
   public static final int TAG_LONG = 3;
   public static final int TAG_DOUBLE = 4;
   public static final int TAG_DATE = 5;
   public static final int TAG_STRING = 6;
   public static final int TAG_XML = 7;
   public static final int TAG_BASE64 = 8;
   public static final int TAG_MAP = 9;
   public static final int TAG_LIST = 10;
   public static final int TAG_TYPE = 11;
   public static final int TAG_LENGTH = 12;
   public static final int TAG_REF = 13;
   public static final int TAG_REMOTE = 14;
   public static final int TAG_CALL = 15;
   public static final int TAG_REPLY = 16;
   public static final int TAG_FAULT = 17;
   public static final int TAG_METHOD = 18;
   public static final int TAG_HEADER = 19;
   public static final int TAG_NULL_END = 100;
   public static final int TAG_BOOLEAN_END = 101;
   public static final int TAG_INT_END = 102;
   public static final int TAG_LONG_END = 103;
   public static final int TAG_DOUBLE_END = 104;
   public static final int TAG_DATE_END = 105;
   public static final int TAG_STRING_END = 106;
   public static final int TAG_XML_END = 107;
   public static final int TAG_BASE64_END = 108;
   public static final int TAG_MAP_END = 109;
   public static final int TAG_LIST_END = 110;
   public static final int TAG_TYPE_END = 111;
   public static final int TAG_LENGTH_END = 112;
   public static final int TAG_REF_END = 113;
   public static final int TAG_REMOTE_END = 114;
   public static final int TAG_CALL_END = 115;
   public static final int TAG_REPLY_END = 116;
   public static final int TAG_FAULT_END = 117;
   public static final int TAG_METHOD_END = 118;
   public static final int TAG_HEADER_END = 119;
   private static HashMap _tagMap = new HashMap();
   private static Field _detailMessageField;
   protected SerializerFactory _serializerFactory;
   protected ArrayList _refs;
   private InputStream _is;
   protected int _peek = -1;
   private String _method;
   private int _peekTag;
   private Throwable _replyFault;
   protected StringBuffer _sbuf = new StringBuffer();
   protected StringBuffer _entityBuffer = new StringBuffer();
   protected Calendar _utcCalendar;
   protected Calendar _localCalendar;


   public BurlapInput() {
   }

   public BurlapInput(InputStream is) {
      this.init(is);
   }

   public void setSerializerFactory(SerializerFactory factory) {
      this._serializerFactory = factory;
   }

   public SerializerFactory getSerializerFactory() {
      return this._serializerFactory;
   }

   public void init(InputStream is) {
      this._is = is;
      this._method = null;
      this._peek = -1;
      this._peekTag = -1;
      this._refs = null;
      this._replyFault = null;
      if(this._serializerFactory == null) {
         this._serializerFactory = new SerializerFactory();
      }

   }

   public String getMethod() {
      return this._method;
   }

   public Throwable getReplyFault() {
      return this._replyFault;
   }

   public void startCall() throws IOException {
      this.readCall();

      while(this.readHeader() != null) {
         this.readObject();
      }

      this.readMethod();
   }

   public int readCall() throws IOException {
      this.expectTag(15);
      byte major = 1;
      byte minor = 0;
      return (major << 16) + minor;
   }

   public String readMethod() throws IOException {
      this.expectTag(18);
      this._method = this.parseString();
      this.expectTag(118);
      return this._method;
   }

   public void completeCall() throws IOException {
      this.expectTag(115);
   }

   public Object readReply(Class expectedClass) throws Throwable {
      this.expectTag(16);
      int tag = this.parseTag();
      if(tag == 17) {
         throw this.prepareFault();
      } else {
         this._peekTag = tag;
         Object value = this.readObject(expectedClass);
         this.expectTag(116);
         return value;
      }
   }

   public void startReply() throws Throwable {
      this.expectTag(16);
      int tag = this.parseTag();
      if(tag == 17) {
         throw this.prepareFault();
      } else {
         this._peekTag = tag;
      }
   }

   private Throwable prepareFault() throws IOException {
      HashMap fault = this.readFault();
      Object detail = fault.get("detail");
      String message = (String)fault.get("message");
      if(detail instanceof Throwable) {
         this._replyFault = (Throwable)detail;
         if(message != null && _detailMessageField != null) {
            try {
               _detailMessageField.set(this._replyFault, message);
            } catch (Throwable var5) {
               ;
            }
         }

         return this._replyFault;
      } else {
         String code = (String)fault.get("code");
         this._replyFault = new BurlapServiceException(message, code, detail);
         return this._replyFault;
      }
   }

   public void completeReply() throws IOException {
      this.expectTag(116);
   }

   public String readHeader() throws IOException {
      int tag = this.parseTag();
      if(tag == 19) {
         this._sbuf.setLength(0);
         String value = this.parseString(this._sbuf).toString();
         this.expectTag(119);
         return value;
      } else {
         this._peekTag = tag;
         return null;
      }
   }

   public void readNull() throws IOException {
      int tag = this.parseTag();
      switch(tag) {
      case 0:
         this.expectTag(100);
         return;
      default:
         throw this.expectedTag("null", tag);
      }
   }

   public boolean readBoolean() throws IOException {
      int tag = this.parseTag();
      boolean value;
      switch(tag) {
      case 0:
         value = false;
         this.expectTag(100);
         return value;
      case 1:
         value = this.parseInt() != 0;
         this.expectTag(101);
         return value;
      case 2:
         value = this.parseInt() != 0;
         this.expectTag(102);
         return value;
      case 3:
         value = this.parseLong() != 0L;
         this.expectTag(103);
         return value;
      case 4:
         value = this.parseDouble() != 0.0D;
         this.expectTag(104);
         return value;
      default:
         throw this.expectedTag("boolean", tag);
      }
   }

   public byte readByte() throws IOException {
      return (byte)this.readInt();
   }

   public short readShort() throws IOException {
      return (short)this.readInt();
   }

   public int readInt() throws IOException {
      int tag = this.parseTag();
      int value;
      switch(tag) {
      case 0:
         byte value1 = 0;
         this.expectTag(100);
         return value1;
      case 1:
         value = this.parseInt();
         this.expectTag(101);
         return value;
      case 2:
         value = this.parseInt();
         this.expectTag(102);
         return value;
      case 3:
         value = (int)this.parseLong();
         this.expectTag(103);
         return value;
      case 4:
         value = (int)this.parseDouble();
         this.expectTag(104);
         return value;
      default:
         throw this.expectedTag("int", tag);
      }
   }

   public long readLong() throws IOException {
      int tag = this.parseTag();
      long value;
      switch(tag) {
      case 0:
         value = 0L;
         this.expectTag(100);
         return value;
      case 1:
         value = (long)this.parseInt();
         this.expectTag(101);
         return value;
      case 2:
         value = (long)this.parseInt();
         this.expectTag(102);
         return value;
      case 3:
         value = this.parseLong();
         this.expectTag(103);
         return value;
      case 4:
         value = (long)this.parseDouble();
         this.expectTag(104);
         return value;
      default:
         throw this.expectedTag("long", tag);
      }
   }

   public float readFloat() throws IOException {
      return (float)this.readDouble();
   }

   public double readDouble() throws IOException {
      int tag = this.parseTag();
      double value;
      switch(tag) {
      case 0:
         value = 0.0D;
         this.expectTag(100);
         return value;
      case 1:
         value = (double)this.parseInt();
         this.expectTag(101);
         return value;
      case 2:
         value = (double)this.parseInt();
         this.expectTag(102);
         return value;
      case 3:
         value = (double)this.parseLong();
         this.expectTag(103);
         return value;
      case 4:
         value = this.parseDouble();
         this.expectTag(104);
         return value;
      default:
         throw this.expectedTag("double", tag);
      }
   }

   public long readUTCDate() throws IOException {
      int tag = this.parseTag();
      if(tag != 5) {
         throw this.error("expected date");
      } else {
         if(this._utcCalendar == null) {
            this._utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
         }

         long value = this.parseDate(this._utcCalendar);
         this.expectTag(105);
         return value;
      }
   }

   public long readLocalDate() throws IOException {
      int tag = this.parseTag();
      if(tag != 5) {
         throw this.error("expected date");
      } else {
         if(this._localCalendar == null) {
            this._localCalendar = Calendar.getInstance();
         }

         long value = this.parseDate(this._localCalendar);
         this.expectTag(105);
         return value;
      }
   }

   public String readString() throws IOException {
      int tag = this.parseTag();
      String value;
      switch(tag) {
      case 0:
         this.expectTag(100);
         return null;
      case 6:
         this._sbuf.setLength(0);
         value = this.parseString(this._sbuf).toString();
         this.expectTag(106);
         return value;
      case 7:
         this._sbuf.setLength(0);
         value = this.parseString(this._sbuf).toString();
         this.expectTag(107);
         return value;
      default:
         throw this.expectedTag("string", tag);
      }
   }

   public Node readNode() throws IOException {
      int tag = this.read();
      switch(tag) {
      case 78:
         return null;
      case 83:
      case 88:
      case 115:
      case 120:
         throw this.error("can\'t cope");
      default:
         throw this.expectedTag("string", tag);
      }
   }

   public byte[] readBytes() throws IOException {
      int tag = this.parseTag();
      switch(tag) {
      case 0:
         this.expectTag(100);
         return null;
      case 8:
         byte[] data = this.parseBytes();
         this.expectTag(108);
         return data;
      default:
         throw this.expectedTag("bytes", tag);
      }
   }

   public int readLength() throws IOException {
      int tag = this.parseTag();
      if(tag != 12) {
         this._peekTag = tag;
         return -1;
      } else {
         int value = this.parseInt();
         this.expectTag(112);
         return value;
      }
   }

   private HashMap readFault() throws IOException {
      HashMap map = new HashMap();

      int code;
      for(code = this.parseTag(); code >= 0 && code != 117; code = this.parseTag()) {
         this._peekTag = code;
         Object key = this.readObject();
         Object value = this.readObject();
         if(key != null && value != null) {
            map.put(key, value);
         }
      }

      if(code != 117) {
         throw this.expectedTag("fault", code);
      } else {
         return map;
      }
   }

   public Object readObject(Class cl) throws IOException {
      if(cl != null && !cl.equals(Object.class)) {
         int tag = this.parseTag();
         String value;
         switch(tag) {
         case 0:
            this.expectTag(100);
            return null;
         case 1:
         case 2:
         case 3:
         case 4:
         case 5:
         case 6:
         case 7:
         case 8:
         case 11:
         case 12:
         default:
            this._peekTag = tag;
            Object value2 = this._serializerFactory.getDeserializer(cl).readObject(this);
            return value2;
         case 9:
            value = this.readType();
            Deserializer url2 = this._serializerFactory.getObjectDeserializer(value, cl);
            return url2.readMap(this);
         case 10:
            value = this.readType();
            int url1 = this.readLength();
            Deserializer remote1 = this._serializerFactory.getObjectDeserializer(value, cl);
            return remote1.readList(this, url1);
         case 13:
            int value1 = this.parseInt();
            this.expectTag(113);
            return this._refs.get(value1);
         case 14:
            value = this.readType();
            String url = this.readString();
            this.expectTag(114);
            Object remote = this.resolveRemote(value, url);
            return remote;
         }
      } else {
         return this.readObject();
      }
   }

   public Object readObject() throws IOException {
      int tag = this.parseTag();
      String type;
      int type1;
      long type3;
      switch(tag) {
      case 0:
         this.expectTag(100);
         return null;
      case 1:
         type1 = this.parseInt();
         this.expectTag(101);
         return new Boolean(type1 != 0);
      case 2:
         type1 = this.parseInt();
         this.expectTag(102);
         return new Integer(type1);
      case 3:
         type3 = this.parseLong();
         this.expectTag(103);
         return new Long(type3);
      case 4:
         double type4 = this.parseDouble();
         this.expectTag(104);
         return new Double(type4);
      case 5:
         type3 = this.parseDate();
         this.expectTag(105);
         return new Date(type3);
      case 6:
         this._sbuf.setLength(0);
         type = this.parseString(this._sbuf).toString();
         this.expectTag(106);
         return type;
      case 7:
         return this.parseXML();
      case 8:
         byte[] type2 = this.parseBytes();
         this.expectTag(108);
         return type2;
      case 9:
         type = this.readType();
         Deserializer url2 = this._serializerFactory.getObjectDeserializer(type);
         return url2.readMap(this);
      case 10:
         type = this.readType();
         int url1 = this.readLength();
         return this._serializerFactory.readList(this, url1, type);
      case 11:
      case 12:
      default:
         throw this.error("unknown code:" + tagName(tag));
      case 13:
         type1 = this.parseInt();
         this.expectTag(113);
         return this._refs.get(type1);
      case 14:
         type = this.readType();
         String url = this.readString();
         this.expectTag(114);
         return this.resolveRemote(type, url);
      }
   }

   public Object readRemote() throws IOException {
      String type = this.readType();
      String url = this.readString();
      return this.resolveRemote(type, url);
   }

   public Object readRef() throws IOException {
      return this._refs.get(this.parseInt());
   }

   public int readListStart() throws IOException {
      return this.parseTag();
   }

   public int readMapStart() throws IOException {
      return this.parseTag();
   }

   public boolean isEnd() throws IOException {
      int code = this.parseTag();
      this._peekTag = code;
      return code < 0 || code >= 100;
   }

   public void readEnd() throws IOException {
      int code = this.parseTag();
      if(code < 100) {
         throw this.error("unknown code:" + (char)code);
      }
   }

   public void readMapEnd() throws IOException {
      this.expectTag(109);
   }

   public void readListEnd() throws IOException {
      this.expectTag(110);
   }

   public int addRef(Object ref) {
      if(this._refs == null) {
         this._refs = new ArrayList();
      }

      this._refs.add(ref);
      return this._refs.size() - 1;
   }

   public void setRef(int i, Object ref) {
      this._refs.set(i, ref);
   }

   public Object resolveRemote(String type, String url) throws IOException {
      HessianRemoteResolver resolver = this.getRemoteResolver();
      return resolver != null?resolver.lookup(type, url):new BurlapRemote(type, url);
   }

   public String readType() throws IOException {
      int code = this.parseTag();
      if(code != 11) {
         this._peekTag = code;
         return "";
      } else {
         this._sbuf.setLength(0);

         int ch;
         while((ch = this.readChar()) >= 0) {
            this._sbuf.append((char)ch);
         }

         String type = this._sbuf.toString();
         this.expectTag(111);
         return type;
      }
   }

   private int parseInt() throws IOException {
      byte sign = 1;
      int ch = this.read();
      if(ch == 45) {
         sign = -1;
         ch = this.read();
      }

      int value;
      for(value = 0; ch >= 48 && ch <= 57; ch = this.read()) {
         value = 10 * value + ch - 48;
      }

      this._peek = ch;
      return sign * value;
   }

   private long parseLong() throws IOException {
      byte sign = 1;
      int ch = this.read();
      if(ch == 45) {
         sign = -1;
         ch = this.read();
      }

      long value;
      for(value = 0L; ch >= 48 && ch <= 57; ch = this.read()) {
         value = 10L * value + (long)ch - 48L;
      }

      this._peek = ch;
      return (long)sign * value;
   }

   private double parseDouble() throws IOException {
      int ch = this.skipWhitespace();
      this._sbuf.setLength(0);

      while(!this.isWhitespace(ch) && ch != 60) {
         this._sbuf.append((char)ch);
         ch = this.read();
      }

      this._peek = ch;
      return (new Double(this._sbuf.toString())).doubleValue();
   }

   protected long parseDate() throws IOException {
      if(this._utcCalendar == null) {
         this._utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
      }

      return this.parseDate(this._utcCalendar);
   }

   protected long parseDate(Calendar calendar) throws IOException {
      int ch = this.skipWhitespace();
      int year = 0;

      int month;
      for(month = 0; month < 4; ++month) {
         if(ch < 48 || ch > 57) {
            throw this.expectedChar("year", ch);
         }

         year = 10 * year + ch - 48;
         ch = this.read();
      }

      month = 0;

      int day;
      for(day = 0; day < 2; ++day) {
         if(ch < 48 || ch > 57) {
            throw this.expectedChar("month", ch);
         }

         month = 10 * month + ch - 48;
         ch = this.read();
      }

      day = 0;

      int hour;
      for(hour = 0; hour < 2; ++hour) {
         if(ch < 48 || ch > 57) {
            throw this.expectedChar("day", ch);
         }

         day = 10 * day + ch - 48;
         ch = this.read();
      }

      if(ch != 84) {
         throw this.expectedChar("`T\'", ch);
      } else {
         ch = this.read();
         hour = 0;

         int minute;
         for(minute = 0; minute < 2; ++minute) {
            if(ch < 48 || ch > 57) {
               throw this.expectedChar("hour", ch);
            }

            hour = 10 * hour + ch - 48;
            ch = this.read();
         }

         minute = 0;

         int second;
         for(second = 0; second < 2; ++second) {
            if(ch < 48 || ch > 57) {
               throw this.expectedChar("minute", ch);
            }

            minute = 10 * minute + ch - 48;
            ch = this.read();
         }

         second = 0;

         int ms;
         for(ms = 0; ms < 2; ++ms) {
            if(ch < 48 || ch > 57) {
               throw this.expectedChar("second", ch);
            }

            second = 10 * second + ch - 48;
            ch = this.read();
         }

         ms = 0;
         if(ch == 46) {
            for(ch = this.read(); ch >= 48 && ch <= 57; ch = this.read()) {
               ms = 10 * ms + ch - 48;
            }
         }

         while(ch > 0 && ch != 60) {
            ch = this.read();
         }

         this._peek = ch;
         calendar.set(1, year);
         calendar.set(2, month - 1);
         calendar.set(5, day);
         calendar.set(11, hour);
         calendar.set(12, minute);
         calendar.set(13, second);
         calendar.set(14, ms);
         return calendar.getTime().getTime();
      }
   }

   protected String parseString() throws IOException {
      this._sbuf.setLength(0);
      return this.parseString(this._sbuf).toString();
   }

   protected StringBuffer parseString(StringBuffer sbuf) throws IOException {
      int ch;
      while((ch = this.readChar()) >= 0) {
         sbuf.append((char)ch);
      }

      return sbuf;
   }

   Node parseXML() throws IOException {
      throw this.error("help!");
   }

   int readChar() throws IOException {
      int ch = this.read();
      if(ch != 60 && ch >= 0) {
         int ch11;
         if(ch != 38) {
            if(ch < 128) {
               return (char)ch;
            } else {
               int ch2;
               if((ch & 224) == 192) {
                  ch11 = this.read();
                  ch2 = ((ch & 31) << 6) + (ch11 & 63);
                  return (char)ch2;
               } else if((ch & 240) == 224) {
                  ch11 = this.read();
                  ch2 = this.read();
                  int v = ((ch & 15) << 12) + ((ch11 & 63) << 6) + (ch2 & 63);
                  return (char)v;
               } else {
                  throw new BurlapProtocolException("bad utf-8 encoding");
               }
            }
         } else {
            ch = this.read();
            if(ch == 35) {
               ch = this.read();
               if(ch >= 48 && ch <= 57) {
                  for(ch11 = 0; ch >= 48 && ch <= 57; ch = this.read()) {
                     ch11 = 10 * ch11 + ch - 48;
                  }

                  if(ch != 59) {
                     throw this.error("expected \';\' at " + (char)ch);
                  } else {
                     return (char)ch11;
                  }
               } else {
                  throw this.error("expected digit at " + (char)ch);
               }
            } else {
               this._entityBuffer.setLength(0);

               while(ch >= 97 && ch <= 122) {
                  this._entityBuffer.append((char)ch);
                  ch = this.read();
               }

               String ch1 = this._entityBuffer.toString();
               if(ch != 59) {
                  throw this.expectedChar("\';\'", ch);
               } else if(ch1.equals("amp")) {
                  return 38;
               } else if(ch1.equals("apos")) {
                  return 39;
               } else if(ch1.equals("quot")) {
                  return 34;
               } else if(ch1.equals("lt")) {
                  return 60;
               } else if(ch1.equals("gt")) {
                  return 62;
               } else {
                  throw new BurlapProtocolException("unknown XML entity &" + ch1 + "; at `" + (char)ch + "\'");
               }
            }
         }
      } else {
         this._peek = ch;
         return -1;
      }
   }

   protected byte[] parseBytes() throws IOException {
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      this.parseBytes(bos);
      return bos.toByteArray();
   }

   protected ByteArrayOutputStream parseBytes(ByteArrayOutputStream bos) throws IOException {
      int ch;
      for(ch = this.skipWhitespace(); ch >= 0 && ch != 60; ch = this.skipWhitespace()) {
         int b2 = this.read();
         int b3 = this.read();
         int b4 = this.read();
         int chunk;
         if(b4 != 61) {
            chunk = (base64Decode[ch] << 18) + (base64Decode[b2] << 12) + (base64Decode[b3] << 6) + base64Decode[b4];
            bos.write(chunk >> 16);
            bos.write(chunk >> 8);
            bos.write(chunk);
         } else if(b3 != 61) {
            chunk = (base64Decode[ch] << 10) + (base64Decode[b2] << 4) + (base64Decode[b3] >> 2);
            bos.write(chunk >> 8);
            bos.write(chunk);
         } else {
            chunk = (base64Decode[ch] << 2) + (base64Decode[b2] >> 4);
            bos.write(chunk);
         }
      }

      if(ch == 60) {
         this._peek = ch;
      }

      return bos;
   }

   public void expectTag(int expectTag) throws IOException {
      int tag = this.parseTag();
      if(tag != expectTag) {
         throw this.error("expected " + tagName(expectTag) + " at " + tagName(tag));
      }
   }

   protected int parseTag() throws IOException {
      int ch;
      if(this._peekTag >= 0) {
         ch = this._peekTag;
         this._peekTag = -1;
         return ch;
      } else {
         ch = this.skipWhitespace();
         byte endTagDelta = 0;
         if(ch != 60) {
            throw this.expectedChar("\'<\'", ch);
         } else {
            ch = this.read();
            if(ch == 47) {
               endTagDelta = 100;
               ch = this._is.read();
            }

            if(!this.isTagChar(ch)) {
               throw this.expectedChar("tag", ch);
            } else {
               this._sbuf.setLength(0);

               while(this.isTagChar(ch)) {
                  this._sbuf.append((char)ch);
                  ch = this.read();
               }

               if(ch != 62) {
                  throw this.expectedChar("\'>\'", ch);
               } else {
                  Integer value = (Integer)_tagMap.get(this._sbuf.toString());
                  if(value == null) {
                     throw this.error("Unknown tag <" + this._sbuf + ">");
                  } else {
                     return value.intValue() + endTagDelta;
                  }
               }
            }
         }
      }
   }

   private boolean isTagChar(int ch) {
      return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 58 || ch == 45;
   }

   protected int skipWhitespace() throws IOException {
      int ch;
      for(ch = this.read(); ch == 32 || ch == 9 || ch == 10 || ch == 13; ch = this.read()) {
         ;
      }

      return ch;
   }

   protected boolean isWhitespace(int ch) throws IOException {
      return ch == 32 || ch == 9 || ch == 10 || ch == 13;
   }

   int read(byte[] buffer, int offset, int length) throws IOException {
      throw new UnsupportedOperationException();
   }

   int read() throws IOException {
      int ch;
      if(this._peek >= 0) {
         ch = this._peek;
         this._peek = -1;
         return ch;
      } else {
         ch = this._is.read();
         return ch;
      }
   }

   public Reader getReader() {
      return null;
   }

   public InputStream readInputStream() {
      return null;
   }

   public InputStream getInputStream() {
      return null;
   }

   protected IOException expectBeginTag(String expect, String tag) {
      return new BurlapProtocolException("expected <" + expect + "> at <" + tag + ">");
   }

   protected IOException expectedChar(String expect, int ch) {
      return ch < 0?this.error("expected " + expect + " at end of file"):this.error("expected " + expect + " at " + (char)ch);
   }

   protected IOException expectedTag(String expect, int tag) {
      return this.error("expected " + expect + " at " + tagName(tag));
   }

   protected IOException error(String message) {
      return new BurlapProtocolException(message);
   }

   protected static String tagName(int tag) {
      switch(tag) {
      case -1:
         return "end of file";
      case 0:
         return "<null>";
      case 1:
         return "<boolean>";
      case 2:
         return "<int>";
      case 3:
         return "<long>";
      case 4:
         return "<double>";
      case 5:
      case 18:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 39:
      case 40:
      case 41:
      case 42:
      case 43:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
      case 58:
      case 59:
      case 60:
      case 61:
      case 62:
      case 63:
      case 64:
      case 65:
      case 66:
      case 67:
      case 68:
      case 69:
      case 70:
      case 71:
      case 72:
      case 73:
      case 74:
      case 75:
      case 76:
      case 77:
      case 78:
      case 79:
      case 80:
      case 81:
      case 82:
      case 83:
      case 84:
      case 85:
      case 86:
      case 87:
      case 88:
      case 89:
      case 90:
      case 91:
      case 92:
      case 93:
      case 94:
      case 95:
      case 96:
      case 97:
      case 98:
      case 99:
      case 105:
      case 118:
      default:
         return "unknown " + tag;
      case 6:
         return "<string>";
      case 7:
         return "<xml>";
      case 8:
         return "<base64>";
      case 9:
         return "<map>";
      case 10:
         return "<list>";
      case 11:
         return "<type>";
      case 12:
         return "<length>";
      case 13:
         return "<ref>";
      case 14:
         return "<remote>";
      case 15:
         return "<burlap:call>";
      case 16:
         return "<burlap:reply>";
      case 17:
         return "<fault>";
      case 19:
         return "<header>";
      case 100:
         return "</null>";
      case 101:
         return "</boolean>";
      case 102:
         return "</int>";
      case 103:
         return "</long>";
      case 104:
         return "</double>";
      case 106:
         return "</string>";
      case 107:
         return "</xml>";
      case 108:
         return "</base64>";
      case 109:
         return "</map>";
      case 110:
         return "</list>";
      case 111:
         return "</type>";
      case 112:
         return "</length>";
      case 113:
         return "</ref>";
      case 114:
         return "</remote>";
      case 115:
         return "</burlap:call>";
      case 116:
         return "</burlap:reply>";
      case 117:
         return "</fault>";
      case 119:
         return "</header>";
      }
   }

   static {
      _tagMap.put("null", new Integer(0));
      _tagMap.put("boolean", new Integer(1));
      _tagMap.put("int", new Integer(2));
      _tagMap.put("long", new Integer(3));
      _tagMap.put("double", new Integer(4));
      _tagMap.put("date", new Integer(5));
      _tagMap.put("string", new Integer(6));
      _tagMap.put("xml", new Integer(7));
      _tagMap.put("base64", new Integer(8));
      _tagMap.put("map", new Integer(9));
      _tagMap.put("list", new Integer(10));
      _tagMap.put("type", new Integer(11));
      _tagMap.put("length", new Integer(12));
      _tagMap.put("ref", new Integer(13));
      _tagMap.put("remote", new Integer(14));
      _tagMap.put("burlap:call", new Integer(15));
      _tagMap.put("burlap:reply", new Integer(16));
      _tagMap.put("fault", new Integer(17));
      _tagMap.put("method", new Integer(18));
      _tagMap.put("header", new Integer(19));
      base64Decode = new int[256];

      int e;
      for(e = 65; e <= 90; ++e) {
         base64Decode[e] = e - 65;
      }

      for(e = 97; e <= 122; ++e) {
         base64Decode[e] = e - 97 + 26;
      }

      for(e = 48; e <= 57; ++e) {
         base64Decode[e] = e - 48 + 52;
      }

      base64Decode[43] = 62;
      base64Decode[47] = 63;

      try {
         _detailMessageField = Throwable.class.getDeclaredField("detailMessage");
         _detailMessageField.setAccessible(true);
      } catch (Throwable var1) {
         ;
      }

   }
}
