package com.caucho.burlap.client;

import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.io.BurlapRemoteResolver;
import java.io.IOException;

public class BurlapProxyResolver implements BurlapRemoteResolver {

   private BurlapProxyFactory factory;


   public BurlapProxyResolver(BurlapProxyFactory factory) {
      this.factory = factory;
   }

   public Object lookup(String type, String url) throws IOException {
      ClassLoader loader = Thread.currentThread().getContextClassLoader();

      try {
         Class e = Class.forName(type, false, loader);
         return this.factory.create(e, url);
      } catch (Exception var5) {
         throw new IOException(String.valueOf(var5));
      }
   }
}
