package com.caucho.burlap.client;

import com.caucho.burlap.client.BurlapMetaInfoAPI;
import com.caucho.burlap.client.BurlapProxy;
import com.caucho.burlap.client.BurlapProxyResolver;
import com.caucho.burlap.client.BurlapRuntimeException;
import com.caucho.burlap.io.AbstractBurlapInput;
import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.burlap.io.BurlapRemoteObject;
import com.caucho.burlap.io.BurlapRemoteResolver;
import com.caucho.services.client.ServiceProxyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class BurlapProxyFactory implements ServiceProxyFactory, ObjectFactory {

   private BurlapRemoteResolver _resolver = new BurlapProxyResolver(this);
   private String _user;
   private String _password;
   private String _basicAuth;
   private long _readTimeout;
   private boolean _isOverloadEnabled = false;


   public void setUser(String user) {
      this._user = user;
      this._basicAuth = null;
   }

   public void setPassword(String password) {
      this._password = password;
      this._basicAuth = null;
   }

   public boolean isOverloadEnabled() {
      return this._isOverloadEnabled;
   }

   public void setOverloadEnabled(boolean isOverloadEnabled) {
      this._isOverloadEnabled = isOverloadEnabled;
   }

   public BurlapRemoteResolver getRemoteResolver() {
      return this._resolver;
   }

   protected URLConnection openConnection(URL url) throws IOException {
      URLConnection conn = url.openConnection();
      conn.setDoOutput(true);
      if(this._basicAuth != null) {
         conn.setRequestProperty("Authorization", this._basicAuth);
      } else if(this._user != null && this._password != null) {
         this._basicAuth = "Basic " + this.base64(this._user + ":" + this._password);
         conn.setRequestProperty("Authorization", this._basicAuth);
      }

      return conn;
   }

   public Object create(String url) throws MalformedURLException, ClassNotFoundException {
      BurlapMetaInfoAPI metaInfo = (BurlapMetaInfoAPI)this.create(BurlapMetaInfoAPI.class, url);
      String apiClassName = (String)metaInfo._burlap_getAttribute("java.api.class");
      if(apiClassName == null) {
         throw new BurlapRuntimeException(url + " has an unknown api.");
      } else {
         ClassLoader loader = Thread.currentThread().getContextClassLoader();
         Class apiClass = Class.forName(apiClassName, false, loader);
         return this.create(apiClass, url);
      }
   }

   public Object create(Class api, String urlName) throws MalformedURLException {
      if(api == null) {
         throw new NullPointerException();
      } else {
         URL url = new URL(urlName);

         try {
            HttpURLConnection handler = (HttpURLConnection)url.openConnection();
            handler.setConnectTimeout(10);
            handler.setReadTimeout(10);
            handler.setRequestProperty("Connection", "close");
            InputStream is = handler.getInputStream();
            is.close();
            handler.disconnect();
         } catch (IOException var6) {
            ;
         }

         BurlapProxy handler1 = new BurlapProxy(this, url);
         return Proxy.newProxyInstance(api.getClassLoader(), new Class[]{api, BurlapRemoteObject.class}, handler1);
      }
   }

   public AbstractBurlapInput getBurlapInput(InputStream is) {
      BurlapInput in = new BurlapInput(is);
      in.setRemoteResolver(this.getRemoteResolver());
      return in;
   }

   public BurlapOutput getBurlapOutput(OutputStream os) {
      BurlapOutput out = new BurlapOutput(os);
      return out;
   }

   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
      Reference ref = (Reference)obj;
      String api = null;
      String url = null;
      Object user = null;
      Object password = null;

      for(int loader = 0; loader < ref.size(); ++loader) {
         RefAddr apiClass = ref.get(loader);
         String type = apiClass.getType();
         String value = (String)apiClass.getContent();
         if(type.equals("type")) {
            api = value;
         } else if(type.equals("url")) {
            url = value;
         } else if(type.equals("user")) {
            this.setUser(value);
         } else if(type.equals("password")) {
            this.setPassword(value);
         }
      }

      if(url == null) {
         throw new NamingException("`url\' must be configured for BurlapProxyFactory.");
      } else if(api == null) {
         throw new NamingException("`type\' must be configured for BurlapProxyFactory.");
      } else {
         ClassLoader var14 = Thread.currentThread().getContextClassLoader();
         Class var15 = Class.forName(api, false, var14);
         return this.create(var15, url);
      }
   }

   private String base64(String value) {
      StringBuffer cb = new StringBuffer();
      boolean i = false;

      long chunk;
      int i1;
      for(i1 = 0; i1 + 2 < value.length(); i1 += 3) {
         chunk = (long)value.charAt(i1);
         chunk = (chunk << 8) + (long)value.charAt(i1 + 1);
         chunk = (chunk << 8) + (long)value.charAt(i1 + 2);
         cb.append(encode(chunk >> 18));
         cb.append(encode(chunk >> 12));
         cb.append(encode(chunk >> 6));
         cb.append(encode(chunk));
      }

      if(i1 + 1 < value.length()) {
         chunk = (long)value.charAt(i1);
         chunk = (chunk << 8) + (long)value.charAt(i1 + 1);
         chunk <<= 8;
         cb.append(encode(chunk >> 18));
         cb.append(encode(chunk >> 12));
         cb.append(encode(chunk >> 6));
         cb.append('=');
      } else if(i1 < value.length()) {
         chunk = (long)value.charAt(i1);
         chunk <<= 16;
         cb.append(encode(chunk >> 18));
         cb.append(encode(chunk >> 12));
         cb.append('=');
         cb.append('=');
      }

      return cb.toString();
   }

   public static char encode(long d) {
      d &= 63L;
      return (char)(d < 26L?(char)((int)(d + 65L)):(d < 52L?(char)((int)(d + 97L - 26L)):(d < 62L?(char)((int)(d + 48L - 52L)):(d == 62L?'+':'/'))));
   }
}
