package com.caucho.burlap.client;

import com.caucho.burlap.client.BurlapProtocolException;
import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import com.caucho.burlap.io.AbstractBurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BurlapProxy implements InvocationHandler {

   private static final Logger log = Logger.getLogger(BurlapProxy.class.getName());
   private BurlapProxyFactory _factory;
   private URL _url;


   BurlapProxy(BurlapProxyFactory factory, URL url) {
      this._factory = factory;
      this._url = url;
   }

   public URL getURL() {
      return this._url;
   }

   public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
      String methodName = method.getName();
      Class[] params = method.getParameterTypes();
      if(methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
         Object is1 = args[0];
         if(is1 != null && Proxy.isProxyClass(is1.getClass())) {
            BurlapProxy conn1 = (BurlapProxy)Proxy.getInvocationHandler(is1);
            return new Boolean(this._url.equals(conn1.getURL()));
         } else {
            return new Boolean(false);
         }
      } else if(methodName.equals("hashCode") && params.length == 0) {
         return new Integer(this._url.hashCode());
      } else if(methodName.equals("getBurlapType")) {
         return proxy.getClass().getInterfaces()[0].getName();
      } else if(methodName.equals("getBurlapURL")) {
         return this._url.toString();
      } else if(methodName.equals("toString") && params.length == 0) {
         return this.getClass().getSimpleName() + "[" + this._url + "]";
      } else {
         InputStream is = null;
         URLConnection conn = null;
         HttpURLConnection httpConn = null;

         Object sb;
         try {
            conn = this._factory.openConnection(this._url);
            httpConn = (HttpURLConnection)conn;
            httpConn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");

            OutputStream e;
            try {
               e = conn.getOutputStream();
            } catch (Exception var29) {
               throw new BurlapRuntimeException(var29);
            }

            BurlapOutput out = this._factory.getBurlapOutput(e);
            if(this._factory.isOverloadEnabled()) {
               if(args != null) {
                  methodName = methodName + "__" + args.length;
               } else {
                  methodName = methodName + "__0";
               }
            }

            if(log.isLoggable(Level.FINE)) {
               log.fine(this + " calling " + methodName + " (" + method + ")");
            }

            out.call(methodName, args);

            try {
               e.flush();
            } catch (Exception var28) {
               throw new BurlapRuntimeException(var28);
            }

            if(conn instanceof HttpURLConnection) {
               httpConn = (HttpURLConnection)conn;
               int in = 500;

               try {
                  in = httpConn.getResponseCode();
               } catch (Exception var27) {
                  ;
               }

               if(in != 200) {
                  StringBuffer sb1 = new StringBuffer();

                  try {
                     is = httpConn.getInputStream();
                     int e1;
                     if(is != null) {
                        while((e1 = is.read()) >= 0) {
                           sb1.append((char)e1);
                        }

                        is.close();
                     }

                     is = httpConn.getErrorStream();
                     if(is != null) {
                        while((e1 = is.read()) >= 0) {
                           sb1.append((char)e1);
                        }
                     }
                  } catch (FileNotFoundException var30) {
                     throw new BurlapRuntimeException(in + ": " + var30);
                  } catch (IOException var31) {
                     ;
                  }

                  if(is != null) {
                     is.close();
                  }

                  throw new BurlapProtocolException(in + ": " + sb1.toString());
               }
            }

            is = conn.getInputStream();
            AbstractBurlapInput in1 = this._factory.getBurlapInput(is);
            sb = in1.readReply(method.getReturnType());
         } catch (BurlapProtocolException var32) {
            throw new BurlapRuntimeException(var32);
         } finally {
            try {
               if(is != null) {
                  is.close();
               }
            } catch (IOException var26) {
               ;
            }

            if(httpConn != null) {
               httpConn.disconnect();
            }

         }

         return sb;
      }
   }

   public String toString() {
      return this.getClass().getSimpleName() + "[" + this._url + "]";
   }

}
