/*
 * Decompiled with CFR 0.152.
 */
package com.jnotify;

import com.huitu.connection.entity.FileInfo;
import com.huitu.connection.util.PropertyUtil;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import net.contentobjects.jnotify.JNotify;
import net.contentobjects.jnotify.JNotifyAdapter;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;

public class EnhancedJNotifyAdapter
extends JNotifyAdapter {
    private static final String REQUEST_BASE_PATH = PropertyUtil.getProperties("monitorDir");
    String path = REQUEST_BASE_PATH;
    int mask = 11;
    boolean watchSubtree = true;
    public int watchID;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    static Connection conn = null;

    public static boolean initJdbc() {
        boolean isSuccessConnection = true;
        if (conn == null) {
            String driverName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            String dbURL = "jdbc:sqlserver://" + PropertyUtil.getProperties("dataBaseIp") + ":" + PropertyUtil.getProperties("dataBasePort") + ";DatabaseName=" + PropertyUtil.getProperties("databasename");
            String userName = PropertyUtil.getProperties("dataBaseUser");
            String userPwd = PropertyUtil.getProperties("dataBasePassword");
            try {
                Class.forName(driverName);
                conn = DriverManager.getConnection(dbURL, userName, userPwd);
            }
            catch (Exception e) {
                e.printStackTrace();
                isSuccessConnection = false;
            }
        }
        return isSuccessConnection;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        if (EnhancedJNotifyAdapter.initJdbc()) {
            System.err.println("\u6570\u636e\u5e93\u521d\u59cb\u80e1\u6210\u529f\uff01");
        } else {
            System.err.println("\u6570\u636e\u5e93\u521d\u59cb\u80e1\u5931\u8d25\uff0c\u7a0b\u5e8f\u5c06\u9000\u51fa\uff01");
            System.exit(0);
        }
        new EnhancedJNotifyAdapter().beginWatch();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void logFileChange(FileInfo fileInfo) {
        Statement ps = null;
        if (EnhancedJNotifyAdapter.initJdbc()) {
            try {
                try {
                    ps = conn.prepareStatement("insert into " + PropertyUtil.getProperties("tablename") + " values(?,?,?,?,?)");
                    ps.setString(1, UUID.randomUUID().toString());
                    ps.setString(2, fileInfo.getFlag() == null ? null : fileInfo.getFlag());
                    ps.setString(3, fileInfo.getDate() == null ? null : fileInfo.getDate());
                    ps.setString(4, fileInfo.getOldFile() == null ? null : fileInfo.getOldFile());
                    ps.setString(5, fileInfo.getNewFile() == null ? null : fileInfo.getNewFile());
                    ps.execute();
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (conn == null) return;
                    try {
                        try {
                            conn.close();
                            return;
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                            conn = null;
                        }
                        return;
                    }
                    finally {
                        conn = null;
                    }
                }
            }
            finally {
                block29: {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        try {
                            try {
                                conn.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                conn = null;
                                break block29;
                            }
                        }
                        catch (Throwable throwable) {
                            conn = null;
                            throw throwable;
                        }
                        conn = null;
                    }
                }
            }
        }
        System.err.println("\u7a0b\u5e8f\u521d\u59cb\u5316\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef...");
    }

    public void beginWatch() throws UnsupportedEncodingException {
        try {
            this.watchID = JNotify.addWatch((String)new String(this.path.getBytes("ISO-8859-1"), "utf-8"), (int)this.mask, (boolean)this.watchSubtree, (JNotifyListener)this);
            System.err.println("jnotify -----------\u542f\u52a8\u6210\u529f-----------");
        }
        catch (JNotifyException e) {
            e.printStackTrace();
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void fileCreated(int wd, String rootPath, String name) {
        System.err.println(new FileInfo("create", this.sdf.format(new Date()), null, String.valueOf(rootPath) + "/" + name).toString());
        EnhancedJNotifyAdapter.logFileChange(new FileInfo("create", this.sdf.format(new Date()), null, String.valueOf(rootPath) + "/" + name));
    }

    public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
        System.err.println(new FileInfo("rename", this.sdf.format(new Date()), String.valueOf(rootPath) + "/" + oldName, String.valueOf(rootPath) + "/" + newName).toString());
        EnhancedJNotifyAdapter.logFileChange(new FileInfo("rename", this.sdf.format(new Date()), String.valueOf(rootPath) + "/" + oldName, String.valueOf(rootPath) + "/" + newName));
    }

    public void fileDeleted(int wd, String rootPath, String name) {
        System.err.println(new FileInfo("delete", this.sdf.format(new Date()), null, String.valueOf(rootPath) + "/" + name).toString());
        EnhancedJNotifyAdapter.logFileChange(new FileInfo("delete", this.sdf.format(new Date()), null, String.valueOf(rootPath) + "/" + name));
    }
}

