/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.UnmodifiableIterator;
import com.topjoy.jdiff.path.DiffPath;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DiffJsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(DiffJsonUtil.class);

    public static void getDiffJsonObject(JSONObject parentObj, DiffPath diffPath, Object objValue) {
        Assert.notNull((Object)parentObj, (String)"Parent json object cannot be null!");
        Assert.notNull((Object)diffPath, (String)"DiffPath cannot be null!");
        UnmodifiableIterator nodeIterator = diffPath.getNodeList().iterator();
        if (nodeIterator.hasNext()) {
            nodeIterator.next();
        }
        objValue = Objects.requireNonNullElse(objValue, "$NULL");
        DiffJsonUtil.getDiffJsonObject(parentObj, (Iterator<DiffPath.DiffNode>)nodeIterator, objValue);
        if (logger.isDebugEnabled()) {
            logger.debug(parentObj.toJSONString());
        }
    }

    private static JSONObject getDiffJsonObject(JSONObject parentObj, Iterator<DiffPath.DiffNode> nodeIterator, Object objValue) {
        if (!nodeIterator.hasNext()) {
            return parentObj;
        }
        DiffPath.DiffNode node = nodeIterator.next();
        String fieldName = node.getFieldName();
        if (!nodeIterator.hasNext()) {
            parentObj.put(fieldName, objValue);
            return parentObj;
        }
        JSONObject currObj = parentObj.containsKey((Object)fieldName) ? parentObj.getJSONObject(fieldName) : new JSONObject();
        JSONObject childObj = DiffJsonUtil.getDiffJsonObject(currObj, nodeIterator, objValue);
        if (childObj != null) {
            parentObj.put(fieldName, (Object)childObj);
        }
        return parentObj;
    }
}

