/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.path;

import com.google.common.collect.ImmutableList;
import com.topjoy.jdiff.DiffConstants;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class DiffPath {
    private final ImmutableList<DiffNode> nodeList;
    private final String diffPath;
    private final String rootClassName;
    private final String updatePath;
    private boolean replaced = false;

    public DiffPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("path cannot be null!");
        }
        String[] nodePaths = StringUtils.split((String)path, (String)DiffConstants.DIFF_SPLIT_NODE);
        ArrayList<DiffNode> list = new ArrayList<DiffNode>();
        StringBuilder strPath = new StringBuilder();
        for (int i = 0; i < nodePaths.length; ++i) {
            String nodePath = nodePaths[i];
            DiffNode node = new DiffNode(nodePath);
            list.add(node);
            if (i <= 0) continue;
            strPath.append(node.fieldName).append(".");
        }
        this.diffPath = path;
        this.updatePath = strPath.length() > 0 ? strPath.substring(0, strPath.length() - 1) : "";
        this.rootClassName = ((DiffNode)list.get(0)).getClassName();
        this.nodeList = ImmutableList.copyOf(list);
    }

    public boolean isParentOf(DiffPath path) {
        if (path.getNodeList().size() <= this.getNodeList().size()) {
            return false;
        }
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (((DiffNode)this.nodeList.get(i)).equals(path.getNodeList().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isChildOf(DiffPath path) {
        if (path.getNodeList().size() >= this.getNodeList().size()) {
            return false;
        }
        for (int i = 0; i < path.nodeList.size(); ++i) {
            if (((DiffNode)this.nodeList.get(i)).equals(path.getNodeList().get(i))) continue;
            return false;
        }
        return true;
    }

    public ImmutableList<DiffNode> getNodeList() {
        return this.nodeList;
    }

    public String getDiffPath() {
        return this.diffPath;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public String getUpdatePath() {
        return this.updatePath;
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    public DiffPath setReplaced(boolean replaced) {
        this.replaced = replaced;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != DiffPath.class) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.diffPath)) {
            return false;
        }
        DiffPath path = (DiffPath)obj;
        return this.diffPath.equals(path.getDiffPath());
    }

    public int hashCode() {
        return this.diffPath.hashCode();
    }

    public String toString() {
        return "DiffPath{nodeList=" + this.nodeList + ", diffPathStr='" + this.diffPath + "'}";
    }

    public static class DiffNode {
        private final String className;
        private final String fieldName;
        private final String nodePath;

        DiffNode(String nodePath) {
            String[] array = StringUtils.split((String)nodePath, (String)DiffConstants.DIFF_SPLIT_FIELD);
            if (array == null || array.length < 2) {
                throw new IllegalArgumentException("Error clzFieldPath! nodePath = " + nodePath);
            }
            this.className = array[0];
            this.fieldName = array[1];
            this.nodePath = nodePath;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != DiffNode.class) {
                return false;
            }
            return obj.toString().equals(this.toString());
        }

        public int hashCode() {
            return this.nodePath.hashCode();
        }

        public String toString() {
            return this.nodePath;
        }
    }
}

