/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.obj;

import com.alibaba.fastjson.annotation.JSONField;
import com.topjoy.jdiff.DiffClassManager;
import com.topjoy.jdiff.DiffContextManager;
import com.topjoy.jdiff.context.IDiffContext;
import com.topjoy.jdiff.log.FieldDiffLog;
import com.topjoy.jdiff.obj.IDiffObject;
import com.topjoy.jdiff.path.DiffPath;
import com.topjoy.jdiff.util.DiffObjectUtil;
import com.topjoy.jdiff.util.DiffPathUtil;
import java.lang.reflect.Field;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.util.Assert;

public class BaseDiffObject<F, V>
implements IDiffObject {
    private static final Logger logger = LoggerFactory.getLogger(BaseDiffObject.class);
    @Transient
    @JSONField(serialize=false)
    private String rootId = null;
    @Transient
    @JSONField(serialize=false)
    private String path;

    public BaseDiffObject() {
    }

    public BaseDiffObject(String rootId, String path) {
        Assert.notNull((Object)rootId, (String)"rootId can not be null!");
        Assert.notNull((Object)path, (String)"path can not be null!");
        this.rootId = rootId;
        this.path = path;
    }

    @Override
    public String getRootId() {
        return this.rootId;
    }

    @Override
    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    protected Object getDiffData() {
        return this;
    }

    protected void updatePath(String fieldName, Object fieldNode) {
        if (this.rootId == null || fieldNode == null || StringUtils.isEmpty((CharSequence)this.path)) {
            return;
        }
        if (fieldNode instanceof IDiffObject) {
            IDiffObject diffObject = (IDiffObject)fieldNode;
            if (!StringUtils.isEmpty((CharSequence)diffObject.getRootId()) && diffObject.getRootId().equals(this.rootId)) {
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)diffObject.getRootId()) && !diffObject.getRootId().equals(this.rootId)) {
                logger.warn("{} The new field has different rootId! fieldRootId:{}, parentRootId:{}", new Object[]{"[diff-warn]", diffObject.getRootId(), this.rootId});
            }
            String fieldPath = DiffPathUtil.joinPath(this.path, this.getClass(), fieldName);
            if (!StringUtils.isEmpty((CharSequence)diffObject.getPath()) && !diffObject.getPath().equals(fieldPath)) {
                logger.warn("{} The new field has different path! fieldPath:{}, newFieldPath:{}", new Object[]{"[diff-warn]", diffObject.getPath(), fieldPath});
            }
            diffObject.setRootId(this.rootId);
            diffObject.setPath(fieldPath);
        }
    }

    protected void fieldChanged(F field, V changedValue, V originValue) {
        Optional<IDiffContext> optionalDiffContext;
        if (originValue != changedValue) {
            DiffObjectUtil.clearDiffObjectState(originValue);
        }
        if ((optionalDiffContext = DiffContextManager.getOptionalDiffContext(this.rootId)).isEmpty() || StringUtils.isEmpty((CharSequence)this.path)) {
            return;
        }
        String fieldName = String.valueOf(field);
        this.updatePath(fieldName, changedValue);
        String fieldPath = DiffPathUtil.joinPath(this.path, this.getClass(), fieldName);
        logger.debug("DiffObject value changed. class = {}, path = {}, origin={}, changed = {}", new Object[]{this.getClass().getSimpleName(), fieldPath, originValue, changedValue});
        DiffPath diffPath = new DiffPath(fieldPath);
        if (originValue instanceof IDiffObject || changedValue instanceof IDiffObject) {
            diffPath.setReplaced(originValue != null);
        }
        IDiffContext diffContext = optionalDiffContext.get();
        diffContext.valueChanged(diffPath, changedValue);
        this.recordDiffLog(diffContext, diffPath, field, originValue, changedValue);
    }

    protected void recordDiffLog(IDiffContext diffContext, DiffPath diffPath, F field, V originValue, V changedValue) {
        Field targetField = DiffClassManager.getField(this.getClass(), String.valueOf(field));
        if (targetField != null) {
            diffContext.recordDiffLog(diffPath, new FieldDiffLog(this, targetField, originValue));
        } else {
            logger.warn("targetField is null, but filed changes happened: field[{}], originValue[{}], changedValue[{}].", new Object[]{field, originValue, changedValue});
        }
    }
}

