/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.log;

import com.topjoy.jdiff.collection.AbstractDMap;
import com.topjoy.jdiff.log.IDiffLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDiffLog<K, V>
implements IDiffLog {
    public static final Logger logger = LoggerFactory.getLogger(MapDiffLog.class);
    private final AbstractDMap<K, V> mapRef;
    private final K key;
    private final V value;

    public MapDiffLog(AbstractDMap<K, V> mapRef, K key, V value) {
        this.mapRef = mapRef;
        this.key = key;
        this.value = value;
    }

    @Override
    public void undo() {
        logger.debug("MapDiffLog: {} rollback to key[{}]-value[{}]", new Object[]{this.mapRef, this.key, this.value});
        this.mapRef.rollbackTo(this.key, this.value);
    }
}

