/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.log;

import com.topjoy.jdiff.log.IDiffLog;
import com.topjoy.jdiff.obj.BaseDiffObject;
import com.topjoy.jdiff.obj.IDiffObject;
import com.topjoy.jdiff.util.DiffPathUtil;
import java.lang.reflect.Field;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldDiffLog
implements IDiffLog {
    public static final Logger logger = LoggerFactory.getLogger(FieldDiffLog.class);
    private final BaseDiffObject parentObj;
    private final Field targetField;
    private final Object originalValue;

    public FieldDiffLog(@Nonnull BaseDiffObject parentObj, @Nonnull Field modifyField, @Nullable Object originalValue) {
        this.parentObj = Objects.requireNonNull(parentObj, "parentObj is null!");
        this.targetField = Objects.requireNonNull(modifyField, "modifyField is null!");
        this.originalValue = originalValue;
    }

    @Override
    public void undo() {
        try {
            if (this.originalValue instanceof IDiffObject) {
                IDiffObject diffObject = (IDiffObject)this.originalValue;
                diffObject.setRootId(this.parentObj.getRootId());
                diffObject.setPath(DiffPathUtil.joinPath(this.parentObj.getPath(), this.parentObj.getClass(), this.targetField.getName()));
            }
            this.targetField.setAccessible(true);
            this.targetField.set(this.parentObj, this.originalValue);
            logger.debug("Field [{}] undo set = {}, path = {}", new Object[]{this.targetField.getName(), this.originalValue, this.parentObj.getPath()});
        }
        catch (IllegalAccessException e) {
            logger.error("undo field error {}|{}: {}", new Object[]{this.parentObj, this.targetField, this.originalValue, e});
        }
    }
}

