/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.context;

import com.alibaba.fastjson.JSONObject;
import com.topjoy.jdiff.DiffClassManager;
import com.topjoy.jdiff.DiffContextManager;
import com.topjoy.jdiff.context.IDiffContext;
import com.topjoy.jdiff.obj.IDiffObject;
import com.topjoy.jdiff.path.DiffPath;
import com.topjoy.jdiff.util.DiffJsonUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.Assert;

public class DiffContext
implements IDiffContext {
    public static final Logger logger = LoggerFactory.getLogger(DiffContext.class);
    private final String diffRootId;
    private final Map<DiffPath.DiffNode, Map<DiffPath, ChangeValue>> diffMap = new HashMap<DiffPath.DiffNode, Map<DiffPath, ChangeValue>>();
    private final Map<DiffPath.DiffNode, Map<DiffPath, ChangeValue>> updateMap = new ConcurrentHashMap<DiffPath.DiffNode, Map<DiffPath, ChangeValue>>();
    private final boolean diffJsonOn;

    public DiffContext(String diffRootId) {
        this.diffRootId = diffRootId;
        this.diffJsonOn = true;
    }

    public DiffContext(String diffRootId, boolean diffJsonOn) {
        this.diffRootId = diffRootId;
        this.diffJsonOn = diffJsonOn;
    }

    @Override
    public String getDiffRootId() {
        return this.diffRootId;
    }

    @Override
    public void valueChanged(DiffPath diffPath, Object changedValue) {
        if (this.diffJsonOn) {
            this.addChangeToMap(this.diffMap, diffPath, changedValue, HashMap::new);
        }
        this.addChangeToMap(this.updateMap, diffPath, changedValue, ConcurrentHashMap::new);
    }

    @Override
    @Nonnull
    public JSONObject getDiffJson() {
        JSONObject diffJsonObject = new JSONObject();
        JSONObject diffData = new JSONObject();
        JSONObject replaceData = new JSONObject();
        if (this.diffJsonOn) {
            this.diffMap.values().forEach(pathChangeValueMap -> pathChangeValueMap.forEach((diffPath, obj) -> {
                if (DiffClassManager.isDiffIgnore(diffPath)) {
                    return;
                }
                if (obj.value != null) {
                    DiffJsonUtil.getDiffJsonObject(diffData, diffPath, obj.value);
                }
                if (obj.value == null || diffPath.isReplaced()) {
                    DiffJsonUtil.getDiffJsonObject(replaceData, diffPath, null);
                }
            }));
            this.diffMap.clear();
        }
        diffJsonObject.put("d", (Object)diffData);
        diffJsonObject.put("r", (Object)replaceData);
        return diffJsonObject;
    }

    @Override
    @Nullable
    public Update getUpdateQuery() {
        AtomicBoolean isChanged = new AtomicBoolean(false);
        Update updateQuery = new Update();
        this.updateMap.values().stream().flatMap(updateChangeMap -> {
            Iterator iterator = updateChangeMap.entrySet().iterator();
            HashMap<DiffPath, ChangeValue> intermediaryMap = new HashMap<DiffPath, ChangeValue>(this.updateMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                iterator.remove();
                DiffPath diffPath = (DiffPath)entry.getKey();
                ChangeValue changedValue = (ChangeValue)entry.getValue();
                this.verifyMap(intermediaryMap, diffPath, changedValue);
            }
            return intermediaryMap.entrySet().stream();
        }).forEach(entry -> {
            DiffPath diffPath = (DiffPath)entry.getKey();
            if (DiffClassManager.isDbIgnore(diffPath)) {
                return;
            }
            String updatePath = diffPath.getUpdatePath();
            if (StringUtils.isEmpty((CharSequence)updatePath)) {
                return;
            }
            isChanged.set(true);
            ChangeValue objValue = (ChangeValue)entry.getValue();
            if (objValue.value == null) {
                updateQuery.unset(updatePath);
            } else {
                updateQuery.set(updatePath, objValue.value);
            }
        });
        return isChanged.get() ? updateQuery : null;
    }

    @Override
    @Nullable
    public Document getSerializedDocument(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter can not be null.");
        Update updateQuery = this.getUpdateQuery();
        if (updateQuery == null) {
            return null;
        }
        UpdateMapper updateMapper = new UpdateMapper(converter);
        MongoPersistentEntity entity = (MongoPersistentEntity)converter.getMappingContext().getPersistentEntity(IDiffObject.class);
        return updateMapper.getMappedObject((Bson)updateQuery.getUpdateObject(), entity);
    }

    @Override
    public void destroy() {
        DiffContextManager.removeDiffContext(this.diffRootId);
    }

    @Override
    public void clear() {
        this.diffMap.clear();
        this.updateMap.clear();
    }

    protected void addChangeToMap(Map<DiffPath.DiffNode, Map<DiffPath, ChangeValue>> diffMap, DiffPath diffPath, Object changedValue, Supplier<Map<DiffPath, ChangeValue>> mapSupplier) {
        if (diffPath.getNodeList().size() < 2) {
            logger.error("Error diffPath! NodeList.size < 2. diffPath:{}", (Object)diffPath);
            return;
        }
        DiffPath.DiffNode moduleRootNode = (DiffPath.DiffNode)diffPath.getNodeList().get(1);
        Map pathChangeValueMap = diffMap.compute(moduleRootNode, (node, map) -> map != null ? map : (Map)mapSupplier.get());
        Iterator iterator = pathChangeValueMap.keySet().iterator();
        while (iterator.hasNext()) {
            DiffPath nodePath = (DiffPath)iterator.next();
            if (nodePath.isParentOf(diffPath)) {
                logger.debug("sub path [{}] ignored because of [{}] already added.", (Object)diffPath, (Object)nodePath);
                return;
            }
            if (!nodePath.isChildOf(diffPath)) continue;
            iterator.remove();
        }
        logger.debug("change path [{}] to value [{}].", (Object)diffPath.getDiffPath(), changedValue);
        pathChangeValueMap.compute(diffPath, (path, obj) -> {
            if (obj != null) {
                diffPath.setReplaced(diffPath.isReplaced() || obj.removed);
            }
            return new ChangeValue(diffPath.isReplaced(), changedValue);
        });
    }

    protected void verifyMap(Map<DiffPath, ChangeValue> diffMap, DiffPath diffPath, ChangeValue changedValue) {
        Iterator<DiffPath> iterator = diffMap.keySet().iterator();
        while (iterator.hasNext()) {
            DiffPath nodePath = iterator.next();
            if (nodePath.isParentOf(diffPath)) {
                return;
            }
            if (!nodePath.isChildOf(diffPath)) continue;
            iterator.remove();
        }
        logger.debug("change path [{}] to value [{}].", (Object)diffPath.getDiffPath(), (Object)changedValue);
        diffMap.putIfAbsent(diffPath, changedValue);
    }

    protected static final class ChangeValue {
        private final boolean removed;
        private final Object value;

        ChangeValue(boolean removed, Object value) {
            this.removed = removed;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

