/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.collection;

import com.google.common.collect.ImmutableList;
import com.topjoy.jdiff.DiffContextManager;
import com.topjoy.jdiff.context.IDiffContext;
import com.topjoy.jdiff.log.ListDiffLog;
import com.topjoy.jdiff.obj.BaseDiffObject;
import com.topjoy.jdiff.path.DiffPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DArrayList<E>
extends BaseDiffObject
implements List<E> {
    private static final Logger logger = LoggerFactory.getLogger(DArrayList.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final int WARNING_SIZE = 200;
    private final ArrayList<E> arrayList;

    public DArrayList() {
        this(10);
    }

    public DArrayList(int initialCapacity) {
        this.arrayList = new ArrayList(initialCapacity);
    }

    @Override
    protected ArrayList<E> getDiffData() {
        return this.arrayList;
    }

    @Override
    public boolean add(E element) {
        this.recordDiffLog();
        this.arrayList.add(element);
        this.selfChanged();
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.recordDiffLog();
        this.arrayList.add(index, element);
        this.selfChanged();
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> collection) {
        this.recordDiffLog();
        this.arrayList.addAll(collection);
        this.selfChanged();
        return true;
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends E> collection) {
        this.recordDiffLog();
        this.arrayList.addAll(index, collection);
        this.selfChanged();
        return true;
    }

    @Override
    public E set(int index, E element) {
        this.recordDiffLog();
        E value = this.arrayList.set(index, element);
        this.selfChanged();
        return value;
    }

    @Override
    public E remove(int index) {
        this.recordDiffLog();
        E value = this.arrayList.remove(index);
        this.selfChanged();
        return value;
    }

    @Override
    public boolean remove(Object object) {
        this.recordDiffLog();
        this.arrayList.remove(object);
        this.selfChanged();
        return true;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> collection) {
        this.recordDiffLog();
        this.arrayList.removeAll(collection);
        this.selfChanged();
        return true;
    }

    @Override
    public void clear() {
        this.recordDiffLog();
        this.arrayList.clear();
        this.selfChanged();
    }

    public void rollbackTo(Collection<E> originCollection) {
        this.arrayList.clear();
        this.arrayList.addAll(originCollection);
    }

    private void recordDiffLog() {
        IDiffContext diffContext = DiffContextManager.getDiffContext(this.getRootId());
        if (diffContext == null) {
            return;
        }
        diffContext.recordDiffLog(new DiffPath(this.getPath()), new ListDiffLog(this, ImmutableList.copyOf((Collection)this)));
    }

    void selfChanged() {
        IDiffContext diffContext = DiffContextManager.getDiffContext(this.getRootId());
        if (diffContext == null) {
            return;
        }
        if (this.size() >= 200) {
            logger.warn("size >= {}, [DHashMap] is better than [DArrayList]. rootId = {}, path = {}, value = {}", new Object[]{200, this.getRootId(), this.getPath(), this.getDiffData()});
        }
        logger.debug("selfChanged. rootId = {}, path = {}, value = {}", new Object[]{this.getRootId(), this.getPath(), this.getDiffData()});
        diffContext.valueChanged(new DiffPath(this.getPath()).setReplaced(true), ImmutableList.copyOf((Collection)this.getDiffData()));
    }

    @Override
    public int size() {
        return this.arrayList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.arrayList.contains(object);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        return this.arrayList.containsAll(collection);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        return this.arrayList.retainAll(collection);
    }

    @Override
    public E get(int index) {
        return this.arrayList.get(index);
    }

    @Override
    public Iterator<E> iterator() {
        return new MyIterator(this.arrayList.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] array) {
        return this.arrayList.toArray(array);
    }

    @Override
    public int indexOf(Object object) {
        return this.arrayList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.arrayList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new MyListIterator(this.arrayList.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new MyListIterator(this.arrayList.listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.arrayList.subList(fromIndex, toIndex);
    }

    public String toString() {
        return this.arrayList.toString();
    }

    private final class MyListIterator
    implements ListIterator<E> {
        private final ListIterator<E> iterator;

        private MyListIterator(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            DArrayList.this.recordDiffLog();
            this.iterator.remove();
            DArrayList.this.selfChanged();
        }

        @Override
        public void set(E element) {
            DArrayList.this.recordDiffLog();
            this.iterator.set(element);
            DArrayList.this.selfChanged();
        }

        @Override
        public void add(E element) {
            DArrayList.this.recordDiffLog();
            this.iterator.add(element);
            DArrayList.this.selfChanged();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public E previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }
    }

    private class MyIterator
    implements Iterator<E> {
        private final Iterator<E> iterator;

        private MyIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            DArrayList.this.recordDiffLog();
            this.iterator.remove();
            DArrayList.this.selfChanged();
        }
    }
}

