/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff.collection;

import com.topjoy.jdiff.context.IDiffContext;
import com.topjoy.jdiff.log.MapDiffLog;
import com.topjoy.jdiff.obj.BaseDiffObject;
import com.topjoy.jdiff.path.DiffPath;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDMap<K, V>
extends BaseDiffObject<K, V>
implements Map<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDMap.class);

    abstract Map<K, V> getMap();

    @Override
    protected Map<K, V> getDiffData() {
        return this.getMap();
    }

    @Override
    protected void recordDiffLog(IDiffContext diffContext, DiffPath diffPath, K field, V originValue, V changedValue) {
        diffContext.recordDiffLog(diffPath, new MapDiffLog<K, V>(this, field, originValue));
    }

    @Override
    public V put(K key, V value) {
        V originValue = this.getMap().get(key);
        if (originValue != value) {
            this.fieldChanged(key, value, originValue);
        }
        return this.getMap().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public V remove(Object key) {
        V removeValue = this.getMap().remove(key);
        if (removeValue != null) {
            this.fieldChanged(key, null, removeValue);
        }
        return removeValue;
    }

    @Override
    public void clear() {
        this.getMap().forEach((key, value) -> this.fieldChanged(key, null, value));
        this.getMap().clear();
    }

    @Override
    public V get(Object key) {
        V v = this.getMap().get(key);
        if (key != null) {
            this.updatePath(key.toString(), v);
        }
        return v;
    }

    public void rollbackTo(K key, V value) {
        if (value == null) {
            this.getMap().remove(key);
        } else {
            this.getMap().put(key, value);
            this.updatePath(key.toString(), value);
        }
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return new MyKeySet(this.getMap().keySet());
    }

    @Override
    public Collection<V> values() {
        return new MyValues(this.getMap().entrySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new MyEntrySet(this.getMap().entrySet());
    }

    public String toString() {
        return this.getMap().toString();
    }

    private final class MyEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> iterator;
        private K currentKey;
        private V currentValue;

        public MyEntryIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry next = this.iterator.next();
            this.currentKey = next.getKey();
            this.currentValue = next.getValue();
            AbstractDMap.this.updatePath(this.currentKey.toString(), this.currentValue);
            return next;
        }

        @Override
        public void remove() {
            AbstractDMap.this.fieldChanged(this.currentKey, null, this.currentValue);
            this.iterator.remove();
        }
    }

    private final class MyValuesIterator
    implements Iterator<V> {
        private final Iterator<Map.Entry<K, V>> iterator;
        private K currentKey;
        private V currentValue;

        public MyValuesIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            Map.Entry next = this.iterator.next();
            this.currentKey = next.getKey();
            this.currentValue = next.getValue();
            AbstractDMap.this.updatePath(this.currentKey.toString(), this.currentValue);
            return this.currentValue;
        }

        @Override
        public void remove() {
            AbstractDMap.this.fieldChanged(this.currentKey, null, this.currentValue);
            this.iterator.remove();
        }
    }

    private final class MyKeyIterator
    implements Iterator<K> {
        private final Iterator<K> iterator;
        private K currentKey;

        public MyKeyIterator(Iterator<K> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.currentKey = this.iterator.next();
            return this.currentKey;
        }

        @Override
        public void remove() {
            AbstractDMap.this.fieldChanged(this.currentKey, null, AbstractDMap.this.get(this.currentKey));
            this.iterator.remove();
        }
    }

    private final class MyEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, V>> entrySet;

        public MyEntrySet(Set<Map.Entry<K, V>> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MyEntryIterator(this.entrySet.iterator());
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }
    }

    private final class MyValues
    extends AbstractCollection<V> {
        private final Set<Map.Entry<K, V>> entrySet;

        public MyValues(Set<Map.Entry<K, V>> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        @Nonnull
        public Iterator<V> iterator() {
            return new MyValuesIterator(this.entrySet.iterator());
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }
    }

    private final class MyKeySet
    extends AbstractSet<K> {
        private final Set<K> keySet;

        public MyKeySet(Set<K> keySet) {
            this.keySet = keySet;
        }

        @Override
        @Nonnull
        public Iterator<K> iterator() {
            return new MyKeyIterator(this.keySet.iterator());
        }

        @Override
        public int size() {
            return this.keySet.size();
        }
    }
}

