/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff;

import com.topjoy.jdiff.context.DiffContext;
import com.topjoy.jdiff.context.IDiffContext;
import com.topjoy.jdiff.context.IDiffContextFactory;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.springframework.util.Assert;

public class DiffContextManager {
    private static volatile DiffContextManager DIFF_OBJECT_MANAGER = new DiffContextManager(DiffContext::new);
    private final ConcurrentHashMap<String, IDiffContext> diffContextMap = new ConcurrentHashMap();
    private final IDiffContextFactory diffContextFactory;
    private final AtomicBoolean removeAll = new AtomicBoolean();

    public DiffContextManager(IDiffContextFactory diffContextFactory) {
        this.diffContextFactory = diffContextFactory;
    }

    public static void init(IDiffContextFactory diffContextFactory) {
        Assert.notNull((Object)diffContextFactory, (String)"diffContextFactory can not be null!");
        DIFF_OBJECT_MANAGER = new DiffContextManager(diffContextFactory);
    }

    @Nullable
    public static IDiffContext getDiffContext(String diffRootId) {
        return DIFF_OBJECT_MANAGER.getOrCreateDiffContext(diffRootId);
    }

    public static Optional<IDiffContext> getOptionalDiffContext(String diffRootId) {
        return Optional.ofNullable(DIFF_OBJECT_MANAGER.getOrCreateDiffContext(diffRootId));
    }

    public static IDiffContext removeDiffContext(String diffRootId) {
        return DiffContextManager.removeDiffContext(diffRootId, false);
    }

    public static IDiffContext removeDiffContext(String diffRootId, boolean isDestroy) {
        IDiffContext diffContext = DIFF_OBJECT_MANAGER.remove(diffRootId);
        if (isDestroy && diffContext != null) {
            diffContext.clear();
        }
        return diffContext;
    }

    public static ArrayList<IDiffContext> getAndRemoveAllDiffContexts() {
        return DIFF_OBJECT_MANAGER.removeAll();
    }

    @Nullable
    private IDiffContext getOrCreateDiffContext(String diffRootId) {
        if (diffRootId == null) {
            return null;
        }
        while (this.removeAll.get()) {
            try {
                Thread.currentThread().wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.diffContextMap.computeIfAbsent(diffRootId, key -> this.diffContextFactory.create(diffRootId));
    }

    private IDiffContext remove(String diffRootId) {
        while (this.removeAll.get()) {
            try {
                Thread.currentThread().wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.diffContextMap.remove(diffRootId);
    }

    private ArrayList<IDiffContext> removeAll() {
        this.removeAll.set(true);
        ArrayList<IDiffContext> list = new ArrayList<IDiffContext>(this.diffContextMap.values());
        this.diffContextMap.clear();
        this.removeAll.set(false);
        return list;
    }
}

