/*
 * Decompiled with CFR 0.152.
 */
package com.topjoy.jdiff;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import com.topjoy.jdiff.obj.IDiffObject;
import com.topjoy.jdiff.path.DiffPath;
import com.topjoy.jdiff.util.DiffPathUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

public class DiffClassManager {
    private static final Logger logger = LoggerFactory.getLogger(DiffClassManager.class);
    private static final Map<Class<? extends IDiffObject>, Map<String, Field>> CLASS_FIELD_MAP = new HashMap<Class<? extends IDiffObject>, Map<String, Field>>();
    private static final Set<String> DIFF_IGNORE_SET = new HashSet<String>();
    private static final Set<String> DB_IGNORE_SET = new HashSet<String>();

    public static void init(String packageName, String ... packageNames) throws UnsupportedOperationException {
        ConfigurationBuilder configuration = new ConfigurationBuilder().forPackages(new String[]{packageName}).forPackages(packageNames).addScanners(new Scanner[]{new SubTypesScanner()});
        DiffClassManager.cacheDiffClasses(new Reflections((Configuration)configuration).getSubTypesOf(IDiffObject.class));
    }

    public static boolean isDiffIgnore(DiffPath diffPath) {
        return diffPath.getNodeList().stream().anyMatch(diffNode -> DIFF_IGNORE_SET.contains(diffNode.toString()));
    }

    public static boolean isDbIgnore(DiffPath diffPath) {
        return diffPath.getNodeList().stream().anyMatch(diffNode -> DB_IGNORE_SET.contains(diffNode.toString()));
    }

    public static Field getField(Class<?> clz, String fieldName) {
        if (!CLASS_FIELD_MAP.containsKey(clz)) {
            throw new IllegalArgumentException(String.format("cannot find field cache for %s.%s", clz.getName(), fieldName));
        }
        return CLASS_FIELD_MAP.get(clz).get(fieldName);
    }

    private static void judgeSameAttribute(Set<Class<? extends IDiffObject>> classes) throws UnsupportedOperationException {
        HashMap<String, List> judgeMap = new HashMap<String, List>(classes.size());
        for (Class<? extends IDiffObject> clz : classes) {
            judgeMap.computeIfAbsent(clz.getSimpleName(), classValue -> new ArrayList()).add(clz);
        }
        HashMap<Map<String, List<Field>>, Map<String, List<String>>> classFieldMap = new HashMap<Map<String, List<Field>>, Map<String, List<String>>>();
        for (String className : judgeMap.keySet()) {
            HashMap sameFieldMap = new HashMap();
            HashMap sameClassMap = new HashMap();
            List sameClassList = (List)judgeMap.get(className);
            if (sameClassList.size() == 1) continue;
            for (Class sameClass : sameClassList) {
                String fullClassName = sameClass.getName();
                Arrays.stream(FieldUtils.getAllFields((Class)sameClass)).forEach(field -> {
                    sameFieldMap.computeIfAbsent(field.getName(), fields -> new ArrayList()).add(field);
                    sameClassMap.computeIfAbsent(field.getName(), sameClasses -> new ArrayList()).add(fullClassName);
                });
            }
            classFieldMap.put(sameFieldMap, sameClassMap);
        }
        DiffClassManager.judgeSameField(classFieldMap);
    }

    private static void judgeSameField(Map<Map<String, List<Field>>, Map<String, List<String>>> classFieldMap) throws UnsupportedOperationException {
        AtomicBoolean isSameField = new AtomicBoolean(false);
        classFieldMap.forEach((sameFieldMap, sameClassMap) -> {
            for (String fieldName : sameFieldMap.keySet()) {
                int diffIgnoreCount;
                List sameFieldList = (List)sameFieldMap.get(fieldName);
                int dbIgnoreCount = diffIgnoreCount = sameFieldList.size();
                if (diffIgnoreCount == 1) continue;
                for (Field sameField : sameFieldList) {
                    JSONField jsonField = sameField.getAnnotation(JSONField.class);
                    if (jsonField != null && !jsonField.serialize()) {
                        --diffIgnoreCount;
                    }
                    if (sameField.isAnnotationPresent(Transient.class)) continue;
                    --dbIgnoreCount;
                }
                int sameFiledSize = sameFieldList.size();
                if (dbIgnoreCount < sameFiledSize && dbIgnoreCount > 0) {
                    logger.error("Db ignore. same Classes: {}, same Field: {}", sameClassMap.get(fieldName), (Object)fieldName);
                    isSameField.set(true);
                }
                if (diffIgnoreCount >= sameFiledSize || diffIgnoreCount <= 0) continue;
                logger.error("Diff ignore. same Classes: {}, same Field: {}", sameClassMap.get(fieldName), (Object)fieldName);
                isSameField.set(true);
            }
        });
        if (isSameField.get()) {
            throw new UnsupportedOperationException("don't allow same Field in same Class");
        }
    }

    private static void cacheDiffClasses(Set<Class<? extends IDiffObject>> classes) throws UnsupportedOperationException {
        DiffClassManager.judgeSameAttribute(classes);
        for (Class<? extends IDiffObject> clz : classes) {
            Field[] fields = FieldUtils.getAllFields(clz);
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)fields.length);
            for (Field field : fields) {
                String fPath = DiffPathUtil.getClassFieldPath(clz, field.getName());
                JSONField jsonField = field.getAnnotation(JSONField.class);
                if (jsonField != null && !jsonField.serialize()) {
                    logger.debug("client ignore [{}]", (Object)fPath);
                    DIFF_IGNORE_SET.add(fPath);
                }
                if (field.isAnnotationPresent(Transient.class)) {
                    logger.debug("db ignore [{}]", (Object)fPath);
                    DB_IGNORE_SET.add(fPath);
                }
                fieldMap.put(field.getName(), field);
            }
            CLASS_FIELD_MAP.put(clz, fieldMap);
        }
    }
}

