/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.tysontheember.orbitalrailgun.client.railgun.RailgunState;

public record S2C_PlayStrikeEffects(BlockPos pos, ResourceKey<Level> dimension, float serverStrikeRadius) {
    public static void encode(S2C_PlayStrikeEffects packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.m_130085_(packet.dimension.m_135782_());
        buf.writeFloat(packet.serverStrikeRadius);
    }

    public static S2C_PlayStrikeEffects decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ResourceLocation dim = buf.m_130281_();
        float radius = buf.readFloat();
        return new S2C_PlayStrikeEffects(pos, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim), radius);
    }

    public static void handle(S2C_PlayStrikeEffects packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> S2C_PlayStrikeEffects.handleClient(packet));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2C_PlayStrikeEffects packet) {
        Minecraft mc = Minecraft.m_91087_();
        RailgunState state = RailgunState.getInstance();
        state.onStrikeStarted(packet.pos(), packet.dimension());
        state.setTransientVisualStrikeRadius(packet.serverStrikeRadius(), 40);
    }
}

