/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.compat;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.tysontheember.orbitalrailgun.compat.ClaimCompat;
import net.tysontheember.orbitalrailgun.compat.FTBChunksCompat;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;

public final class FTBGuard {
    private FTBGuard() {
    }

    public static boolean canBreakBlock(ServerLevel level, ServerPlayer shooter, BlockPos pos) {
        if (!ClaimCompat.hasFTB()) {
            return true;
        }
        if (!FTBChunksCompat.isPositionClaimed(level, pos)) {
            return true;
        }
        if (!((Boolean)OrbitalConfig.ALLOW_BLOCK_BREAK_IN_CLAIMS.get()).booleanValue()) {
            return false;
        }
        return FTBChunksCompat.canModifyBlock(level, pos, shooter);
    }

    public static boolean canDamageEntity(ServerLevel level, ServerPlayer shooter, Entity target) {
        if (!ClaimCompat.hasFTB()) {
            return true;
        }
        if (!FTBChunksCompat.isPositionClaimed(level, target.m_20183_())) {
            return true;
        }
        if (!((Boolean)OrbitalConfig.ALLOW_ENTITY_DAMAGE_IN_CLAIMS.get()).booleanValue()) {
            return false;
        }
        return FTBChunksCompat.canDamageEntity(level, target, shooter);
    }

    public static boolean canAffectPosFromPos(ServerLevel level, BlockPos targetPos, ServerPlayer shooter) {
        if (!ClaimCompat.hasFTB()) {
            return true;
        }
        if (!FTBChunksCompat.isPositionClaimed(level, targetPos)) {
            return true;
        }
        if (!((Boolean)OrbitalConfig.ALLOW_EXPLOSIONS_IN_CLAIMS.get()).booleanValue()) {
            return false;
        }
        return FTBChunksCompat.canExplode(level, targetPos, shooter);
    }
}

