/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.client.railgun;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tysontheember.orbitalrailgun.ForgeOrbitalRailgunMod;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;
import net.tysontheember.orbitalrailgun.item.OrbitalRailgunItem;
import org.jetbrains.annotations.Nullable;

public final class RailgunState {
    private static final RailgunState INSTANCE = new RailgunState();
    private static final int MIN_WARMUP_TICKS = 20;
    private boolean charging;
    private int chargeTicks;
    private boolean requestedFire;
    private boolean hudHidden;
    private float cooldownPercent;
    private HitKind hitKind = HitKind.NONE;
    private Vec3 hitPos = Vec3.f_82478_;
    private float hitDistance;
    private HitResult currentHit;
    private OrbitalRailgunItem activeRailgun;
    private boolean lastCharging;
    private boolean strikeActive;
    private int strikeTicks;
    private Vec3 strikePos = Vec3.f_82478_;
    private ResourceKey<Level> strikeDimension;
    private float transientVisualStrikeRadius = Float.NaN;
    private int transientVisualStrikeRadiusTicks;

    private RailgunState() {
    }

    public static RailgunState getInstance() {
        return INSTANCE;
    }

    public void tick(Minecraft minecraft) {
        boolean wasCharging;
        if (minecraft.m_91104_()) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        this.activeRailgun = this.getActiveRailgun(player);
        this.cooldownPercent = player != null ? player.m_36335_().m_41521_((Item)ForgeOrbitalRailgunMod.ORBITAL_RAILGUN.get(), minecraft.m_91296_()) : 0.0f;
        this.lastCharging = wasCharging = this.charging;
        boolean bl = this.charging = player != null && this.activeRailgun != null && player.m_6117_();
        if (this.charging) {
            ++this.chargeTicks;
            this.requestedFire = this.requestedFire && player.m_6117_();
            this.updateHitInformation(minecraft, player);
        } else {
            this.chargeTicks = 0;
            this.requestedFire = false;
            this.hitKind = HitKind.NONE;
            this.hitPos = Vec3.f_82478_;
            this.hitDistance = 0.0f;
            this.currentHit = null;
        }
        if (this.strikeActive) {
            ++this.strikeTicks;
            if (this.strikeTicks >= 1600) {
                this.clearStrike();
            } else if (minecraft.f_91073_ == null || minecraft.f_91073_.m_46472_() != this.strikeDimension) {
                this.clearStrike();
            }
        }
        if (this.transientVisualStrikeRadiusTicks > 0) {
            --this.transientVisualStrikeRadiusTicks;
            if (this.transientVisualStrikeRadiusTicks <= 0) {
                this.transientVisualStrikeRadius = Float.NaN;
            }
        }
    }

    private void updateHitInformation(Minecraft minecraft, LocalPlayer player) {
        BlockHitResult result = null;
        ClientLevel level = minecraft.f_91073_;
        if (level != null) {
            Vec3 start = player.m_20299_(1.0f);
            Vec3 direction = player.m_20252_(1.0f);
            double distance = Math.max(1.0, (Double)OrbitalConfig.RANGE.get());
            Vec3 end = start.m_82549_(direction.m_82490_(distance));
            ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
            result = level.m_45547_(context);
        }
        this.currentHit = result;
        if (result == null) {
            this.hitKind = HitKind.NONE;
            this.hitPos = Vec3.f_82478_;
            this.hitDistance = 0.0f;
            return;
        }
        switch (result.m_6662_()) {
            case BLOCK: {
                BlockHitResult blockHitResult = result;
                this.hitKind = HitKind.BLOCK;
                this.hitPos = Vec3.m_82512_((Vec3i)blockHitResult.m_82425_());
                this.hitDistance = (float)player.m_20182_().m_82554_(this.hitPos);
                break;
            }
            case ENTITY: {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                this.hitKind = HitKind.ENTITY;
                this.hitPos = entityHitResult.m_82450_();
                this.hitDistance = (float)player.m_20182_().m_82554_(this.hitPos);
                break;
            }
            default: {
                this.hitKind = HitKind.NONE;
                this.hitPos = Vec3.f_82478_;
                this.hitDistance = 0.0f;
            }
        }
    }

    @Nullable
    private OrbitalRailgunItem getActiveRailgun(@Nullable LocalPlayer player) {
        if (player == null) {
            return null;
        }
        Item item = player.m_21211_().m_41720_();
        if (item instanceof OrbitalRailgunItem) {
            OrbitalRailgunItem railgun = (OrbitalRailgunItem)item;
            return railgun;
        }
        return null;
    }

    public boolean canRequestFire(LocalPlayer player) {
        if (!this.charging || this.requestedFire || this.strikeActive || this.activeRailgun == null) {
            return false;
        }
        if (this.chargeTicks < 20) {
            return false;
        }
        if (player == null || player.m_36335_().m_41519_((Item)this.activeRailgun)) {
            return false;
        }
        return this.hitKind != HitKind.NONE;
    }

    public void markFired() {
        this.requestedFire = true;
    }

    public boolean isCharging() {
        return this.charging;
    }

    public boolean wasChargingLastTick() {
        return this.lastCharging;
    }

    public float getChargeSeconds(float partialTicks) {
        return ((float)this.chargeTicks + partialTicks) / 20.0f;
    }

    public float getChargeProgress() {
        if (!this.charging) {
            return 0.0f;
        }
        return Math.min((float)this.chargeTicks / 40.0f, 1.0f);
    }

    public static float getClientChargeProgress() {
        return INSTANCE.getChargeProgress();
    }

    public float getCooldownPercent() {
        return this.cooldownPercent;
    }

    public HitKind getHitKind() {
        return this.hitKind;
    }

    public Vec3 getHitPos() {
        return this.hitPos;
    }

    public float getHitDistance() {
        return this.hitDistance;
    }

    public HitResult getCurrentHit() {
        return this.currentHit;
    }

    @Nullable
    public OrbitalRailgunItem getActiveRailgunItem() {
        return this.activeRailgun;
    }

    public void onStrikeStarted(BlockPos blockPos, ResourceKey<Level> dimension) {
        this.strikeActive = true;
        this.strikeTicks = 0;
        this.strikePos = Vec3.m_82512_((Vec3i)blockPos);
        this.strikeDimension = dimension;
    }

    public boolean isStrikeActive() {
        return this.strikeActive;
    }

    public Vec3 getStrikePos() {
        return this.strikePos;
    }

    public float getStrikeSeconds(float partialTicks) {
        return ((float)this.strikeTicks + partialTicks) / 20.0f;
    }

    public ResourceKey<Level> getStrikeDimension() {
        return this.strikeDimension;
    }

    public void clearStrike() {
        this.strikeActive = false;
        this.strikeTicks = 0;
        this.strikePos = Vec3.f_82478_;
        this.strikeDimension = null;
        this.transientVisualStrikeRadius = Float.NaN;
        this.transientVisualStrikeRadiusTicks = 0;
    }

    public void setTransientVisualStrikeRadius(float radius, int ttlTicks) {
        this.transientVisualStrikeRadius = Math.max(0.0f, radius);
        this.transientVisualStrikeRadiusTicks = Math.max(0, ttlTicks);
    }

    public Optional<Float> getTransientVisualStrikeRadius() {
        if (this.transientVisualStrikeRadiusTicks > 0 && !Float.isNaN(this.transientVisualStrikeRadius)) {
            return Optional.of(Float.valueOf(this.transientVisualStrikeRadius));
        }
        return Optional.empty();
    }

    public static enum HitKind {
        NONE,
        BLOCK,
        ENTITY;

    }
}

