/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.orbitalrailgun.client;

import com.mojang.blaze3d.shaders.Uniform;
import java.util.List;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostPass;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tysontheember.orbitalrailgun.client.ClientUtil;
import net.tysontheember.orbitalrailgun.config.OrbitalConfig;

@OnlyIn(value=Dist.CLIENT)
public final class OrbitalShaderUniforms {
    private OrbitalShaderUniforms() {
    }

    public static void applyColorUniforms(List<PostPass> passes) {
        if (passes == null || passes.isEmpty()) {
            return;
        }
        OrbitalConfig.Client c = OrbitalConfig.CLIENT;
        float[] beam = ClientUtil.parseHexColor((String)c.beamColorHex.get(), (Double)c.beamAlpha.get());
        float[] inner = ClientUtil.parseHexColor((String)c.markerInnerHex.get(), (Double)c.markerInnerAlpha.get());
        float[] outer = ClientUtil.parseHexColor((String)c.markerOuterHex.get(), (Double)c.markerOuterAlpha.get());
        for (PostPass pass : passes) {
            EffectInstance shader = pass.m_110074_();
            if (shader == null) continue;
            OrbitalShaderUniforms.set3f(shader, "u_BeamColor", beam[0], beam[1], beam[2]);
            OrbitalShaderUniforms.set1f(shader, "u_BeamAlpha", beam[3]);
            OrbitalShaderUniforms.set3f(shader, "u_MarkerInnerColor", inner[0], inner[1], inner[2]);
            OrbitalShaderUniforms.set1f(shader, "u_MarkerInnerAlpha", inner[3]);
            OrbitalShaderUniforms.set3f(shader, "u_MarkerOuterColor", outer[0], outer[1], outer[2]);
            OrbitalShaderUniforms.set1f(shader, "u_MarkerOuterAlpha", outer[3]);
        }
    }

    private static void set1f(EffectInstance shader, String name, float v) {
        Uniform u = shader.m_108952_(name);
        if (u != null) {
            u.m_5985_(v);
        }
    }

    private static void set3f(EffectInstance shader, String name, float x, float y, float z) {
        Uniform u = shader.m_108952_(name);
        if (u != null) {
            u.m_5889_(x, y, z);
        }
    }
}

